package com.bizunited.platform.mars.repository;
import com.bizunited.platform.mars.entity.RuleSourceScriptEntity;
import java.lang.String;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * RuleSourceScriptEntity业务模型的数据库方法支持
 * @author saturn
 */
@Repository("_RuleSourceScriptEntityRepository")
public interface RuleSourceScriptEntityRepository
    extends
      JpaRepository<RuleSourceScriptEntity, String>
      ,JpaSpecificationExecutor<RuleSourceScriptEntity>
  {
  /**
   * 按照标准的后端脚本信息进行详情查询（包括关联信息）
   * @param script 标准的后端脚本信息
   * */
  @Query("select distinct ruleSourceScriptEntity from RuleSourceScriptEntity ruleSourceScriptEntity "
      + " left join fetch ruleSourceScriptEntity.script ruleSourceScriptEntity_script "
       + " where ruleSourceScriptEntity_script.id = :id")
  public Set<RuleSourceScriptEntity> findDetailsByScript(@Param("id") String id);

  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   * */
  @Query("select distinct ruleSourceScriptEntity from RuleSourceScriptEntity ruleSourceScriptEntity "
      + " left join fetch ruleSourceScriptEntity.script ruleSourceScriptEntity_script "
      + " where ruleSourceScriptEntity.id=:id ")
  public RuleSourceScriptEntity findDetailsById(@Param("id") String id);



}