package com.bizunited.platform.mars.repository.internal;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

import com.bizunited.platform.mars.entity.RuleDefinitionEntity;

/**
 * 基于规则定义的自定义查询方法
 * @author yinwenjie
 */
@Repository("RuleDefinitionEntityRepositoryCustom")
public interface RuleDefinitionEntityRepositoryCustom {
  /**
   * 分页查询当前已建立的所有规则定义信息。
   * @param pageable 分页要求
   * @param code 规则定义编号
   * @param desc 规则定义描述
   */
  Page<RuleDefinitionEntity> findByConditions(Pageable pageable  , String code , String desc);
}
