package com.bizunited.platform.mars.repository;

import java.lang.String;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import com.bizunited.platform.mars.entity.RuleLockNodeEntity;

/**
 * RuleLockNodeEntity业务模型的数据库方法支持
 * @author saturn
 */
@Repository("_RuleLockNodeEntityRepository")
public interface RuleLockNodeEntityRepository
    extends
      JpaRepository<RuleLockNodeEntity, String>
      ,JpaSpecificationExecutor<RuleLockNodeEntity>
  {

  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   * */
  @Query("select distinct ruleLockNodeEntity from RuleLockNodeEntity ruleLockNodeEntity "
      + " where ruleLockNodeEntity.id=:id ")
  public RuleLockNodeEntity findDetailsById(@Param("id") String id);



}