package com.bizunited.platform.mars.service.internal;

import com.bizunited.platform.mars.entity.RuleTemplateParamsEntity;
import com.bizunited.platform.mars.repository.RuleTemplateParamsEntityRepository;
import com.bizunited.platform.mars.service.RuleTemplateParamsService;
import com.google.common.collect.Sets;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * RuleTemplateParamsEntity业务模型的服务层接口实现
 * @author saturn
 */
@Service("RuleTemplateParamsEntityServiceImpl")
public class RuleTemplateParamsServiceImpl implements RuleTemplateParamsService { 
  @Autowired
  private RuleTemplateParamsEntityRepository ruleTemplateParamsEntityRepository;
  @Transactional
  @Override
  public RuleTemplateParamsEntity create(RuleTemplateParamsEntity ruleTemplateParamsEntity) { 
    RuleTemplateParamsEntity current = this.createForm(ruleTemplateParamsEntity);
    //==================================================== 
    //    这里可以处理第三方系统调用（或特殊处理过程）
    //====================================================
    return current;
  } 
  @Transactional
  @Override
  public RuleTemplateParamsEntity createForm(RuleTemplateParamsEntity ruleTemplateParamsEntity) { 
    this.createValidation(ruleTemplateParamsEntity);
    
    // ===============================
    //  和业务有关的验证填写在这个区域    
    // ===============================
    this.ruleTemplateParamsEntityRepository.save(ruleTemplateParamsEntity);
    
    // 返回最终处理的结果，里面带有详细的关联信息
    return ruleTemplateParamsEntity;
  }
  /**
   * 在创建一个新的RuleTemplateParamsEntity模型对象之前，检查对象各属性的正确性，其主键属性必须没有值
   */
  private void createValidation(RuleTemplateParamsEntity ruleTemplateParamsEntity) { 
    Validate.notNull(ruleTemplateParamsEntity , "进行当前操作时，信息对象必须传入!!");
    // 判定那些不能为null的输入值：条件为 caninsert = true，且nullable = false
    Validate.isTrue(StringUtils.isBlank(ruleTemplateParamsEntity.getId()), "添加信息时，当期信息的数据编号（主键）不能有值！");
    ruleTemplateParamsEntity.setId(null);
    Validate.notNull(ruleTemplateParamsEntity.getType(), "添加信息时，出参还是入参：1、入参；2、出参不能为空！");
    Validate.notBlank(ruleTemplateParamsEntity.getParamDesc(), "添加信息时，参数中文说明不能为空！");
    Validate.notBlank(ruleTemplateParamsEntity.getParamLabel(), "添加信息时，参数中文名不能为空！");
    Validate.notBlank(ruleTemplateParamsEntity.getParamName(), "添加信息时，参数名不能为空！");
    Validate.notNull(ruleTemplateParamsEntity.getParamType(), "添加信息时，参数类型不能为空！");
    Validate.notNull(ruleTemplateParamsEntity.getNullable(), "添加信息时，参数是否可为null不能为空！");
    // 验证长度，被验证的这些字段符合特征: 字段类型为String，且不为PK （注意连续空字符串的情况） 
    Validate.isTrue(ruleTemplateParamsEntity.getParamDesc() == null || ruleTemplateParamsEntity.getParamDesc().length() < 512 , "参数中文说明,在进行添加时填入值超过了限定长度(512)，请检查!");
    Validate.isTrue(ruleTemplateParamsEntity.getParamName() == null || ruleTemplateParamsEntity.getParamName().length() < 128 , "参数名,在进行添加时填入值超过了限定长度(128)，请检查!");
  }
  @Transactional
  @Override
  public RuleTemplateParamsEntity update(RuleTemplateParamsEntity ruleTemplateParamsEntity) { 
    RuleTemplateParamsEntity current = this.updateForm(ruleTemplateParamsEntity);
    //==================================================== 
    //    这里可以处理第三方系统调用（或特殊处理过程）
    //====================================================
    return current;
  } 
  @Transactional
  @Override
  public RuleTemplateParamsEntity updateForm(RuleTemplateParamsEntity ruleTemplateParamsEntity) { 
    this.updateValidation(ruleTemplateParamsEntity);
    // ===================基本信息
    String currentId = ruleTemplateParamsEntity.getId();
    Optional<RuleTemplateParamsEntity> op_currentRuleTemplateParamsEntity = this.ruleTemplateParamsEntityRepository.findById(currentId);
    RuleTemplateParamsEntity currentRuleTemplateParamsEntity = op_currentRuleTemplateParamsEntity.orElse(null);
    currentRuleTemplateParamsEntity = Validate.notNull(currentRuleTemplateParamsEntity ,"未发现指定的原始模型对象信");
    // 开始重新赋值——一般属性
    currentRuleTemplateParamsEntity.setType(ruleTemplateParamsEntity.getType());
    currentRuleTemplateParamsEntity.setParamDesc(ruleTemplateParamsEntity.getParamDesc());
    currentRuleTemplateParamsEntity.setParamLabel(ruleTemplateParamsEntity.getParamLabel());
    currentRuleTemplateParamsEntity.setParamName(ruleTemplateParamsEntity.getParamName());
    currentRuleTemplateParamsEntity.setParamType(ruleTemplateParamsEntity.getParamType());
    currentRuleTemplateParamsEntity.setNullable(ruleTemplateParamsEntity.getNullable());
    currentRuleTemplateParamsEntity.setTemplateNode(ruleTemplateParamsEntity.getTemplateNode());
    
    this.ruleTemplateParamsEntityRepository.saveAndFlush(currentRuleTemplateParamsEntity);
    return currentRuleTemplateParamsEntity;
  }
  /**
   * 在更新一个已有的RuleTemplateParamsEntity模型对象之前，该私有方法检查对象各属性的正确性，其id属性必须有值
   */
  private void updateValidation(RuleTemplateParamsEntity ruleTemplateParamsEntity) { 
    Validate.isTrue(!StringUtils.isBlank(ruleTemplateParamsEntity.getId()), "修改信息时，当期信息的数据编号（主键）必须有值！");
    
    // 基础信息判断，基本属性，需要满足not null
    Validate.notNull(ruleTemplateParamsEntity.getType(), "修改信息时，出参还是入参：1、入参；2、出参不能为空！");
    Validate.notBlank(ruleTemplateParamsEntity.getParamDesc(), "修改信息时，参数中文说明不能为空！");
    Validate.notBlank(ruleTemplateParamsEntity.getParamLabel(), "修改信息时，参数中文名不能为空！");
    Validate.notBlank(ruleTemplateParamsEntity.getParamName(), "修改信息时，参数名不能为空！");
    Validate.notNull(ruleTemplateParamsEntity.getParamType(), "修改信息时，参数类型不能为空！");
    Validate.notNull(ruleTemplateParamsEntity.getNullable(), "修改信息时，参数是否可为null不能为空！");
    // 验证长度，被验证的这些字段符合特征: 字段类型为String，且不为PK，且canupdate = true
    Validate.isTrue(ruleTemplateParamsEntity.getParamDesc() == null || ruleTemplateParamsEntity.getParamDesc().length() < 512 , "参数中文说明,在进行修改时填入值超过了限定长度(512)，请检查!");
    Validate.isTrue(ruleTemplateParamsEntity.getParamName() == null || ruleTemplateParamsEntity.getParamName().length() < 128 , "参数名,在进行修改时填入值超过了限定长度(128)，请检查!");
    
    // 关联性判断，关联属性判断，需要满足ManyToOne或者OneToOne，且not null 且是主模型
  } 
  @Override
  public Set<RuleTemplateParamsEntity> findDetailsByTemplateNode(String templateNode) { 
    if(StringUtils.isBlank(templateNode)) { 
      return Sets.newHashSet();
    }
    return this.ruleTemplateParamsEntityRepository.findDetailsByTemplateNode(templateNode);
  }
  @Override
  public RuleTemplateParamsEntity findDetailsById(String id) { 
    if(StringUtils.isBlank(id)) { 
      return null;
    }
    return this.ruleTemplateParamsEntityRepository.findDetailsById(id);
  }
  @Override
  public RuleTemplateParamsEntity findById(String id) { 
    if(StringUtils.isBlank(id)) { 
      return null;
    }
    
    Optional<RuleTemplateParamsEntity> op = ruleTemplateParamsEntityRepository.findById(id);
    return op.orElse(null); 
  }
  @Override
  @Transactional
  public void deleteById(String id) {
    // 只有存在才进行删除
    RuleTemplateParamsEntity current = this.findById(id);
    if(current != null) { 
      this.ruleTemplateParamsEntityRepository.delete(current);
    }
  }
  @Override
  @Transactional
  public void deleteByTemplateNode(String templateNodeId) {
    Validate.notBlank(templateNodeId , "进行删除时，必须给定模板编号信息!!");
    this.ruleTemplateParamsEntityRepository.deleteByTemplateNode(templateNodeId);;
  }
} 
