package com.bizunited.platform.mars.service.internal;

import com.bizunited.platform.common.util.ApplicationContextUtils;
import com.bizunited.platform.mars.entity.RuleNodeParamsEntity;
import com.bizunited.platform.mars.repository.RuleNodeParamsEntityRepository;
import com.bizunited.platform.mars.service.RuleNodeParamsEntityService;
import com.google.common.collect.Sets;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * RuleNodeParamsEntity业务模型的服务层接口实现
 * @author saturn
 */
@Service("RuleNodeParamsEntityServiceImpl")
public class RuleNodeParamsEntityServiceImpl implements RuleNodeParamsEntityService { 
  @Autowired
  private RuleNodeParamsEntityRepository ruleNodeParamsEntityRepository;
  @Transactional
  @Override
  public RuleNodeParamsEntity create(RuleNodeParamsEntity ruleNodeParamsEntity) { 
    RuleNodeParamsEntity current = this.createForm(ruleNodeParamsEntity);
    //==================================================== 
    //    这里可以处理第三方系统调用（或特殊处理过程）
    //====================================================
    return current;
  } 
  @Transactional
  @Override
  public RuleNodeParamsEntity createForm(RuleNodeParamsEntity ruleNodeParamsEntity) { 
   /* 
    * 针对1.1.3版本的需求，这个对静态模型的保存操作做出调整，新的包裹过程为：
    * 1、如果当前模型对象不是主模型
    * 1.1、那么创建前只会验证基本信息，直接的ManyToOne关联（单选）和ManyToMany关联（多选）
    * 1.2、验证完成后，也只会保存当前对象的基本信息，直接的单选
    * TODO 1.3、ManyToMany的关联（多选），暂时需要开发人员自行处理
    * 2、如果当前模型对象是主业务模型
    *  2.1、创建前会验证当前模型的基本属性，单选和多选属性
    *  2.2、然后还会验证当前模型关联的各个OneToMany明细信息，调用明细对象的服务，明每一条既有明细进行验证
    *  （2.2的步骤还需要注意，如果当前被验证的关联对象是回溯对象，则不需要验证了）
    * 2.3、还会验证当前模型关联的各个OneToOne分组，调用分组对象的服务，对分组中的信息进行验证
    *   2.3.1、包括验证每一个分组项的基本信息、直接的单选、多选信息
    *   2.3.2、以及验证每个分组的OneToMany明细信息
    * */
    this.createValidation(ruleNodeParamsEntity);
    
    // ===============================
    //  和业务有关的验证填写在这个区域    
    // ===============================
    ruleNodeParamsEntity.setProjectName(ApplicationContextUtils.getProjectName());
    this.ruleNodeParamsEntityRepository.save(ruleNodeParamsEntity);
    
    // 返回最终处理的结果，里面带有详细的关联信息
    return ruleNodeParamsEntity;
  }
  /**
   * 在创建一个新的RuleNodeParamsEntity模型对象之前，检查对象各属性的正确性，其主键属性必须没有值
   */
  private void createValidation(RuleNodeParamsEntity ruleNodeParamsEntity) { 
    Validate.notNull(ruleNodeParamsEntity , "进行当前操作时，信息对象必须传入!!");
    // 判定那些不能为null的输入值：条件为 caninsert = true，且nullable = false
    Validate.isTrue(StringUtils.isBlank(ruleNodeParamsEntity.getId()), "添加信息时，当期信息的数据编号（主键）不能有值！");
    ruleNodeParamsEntity.setId(null);
    Validate.notNull(ruleNodeParamsEntity.getType(), "添加信息时，出参还是入参：1、入参；2、出参不能为空！");
    Validate.notBlank(ruleNodeParamsEntity.getParamDesc(), "添加信息时，参数中文说明不能为空！");
    String contextParamName = ruleNodeParamsEntity.getContextParamName();
    String fixedValue = ruleNodeParamsEntity.getFixedValue();
    if(StringUtils.isEmpty(contextParamName) && StringUtils.isEmpty(fixedValue)) {
      throw new IllegalArgumentException("添加信息时，入参来源必须从“固定值”/“上下文绑定”两种方式中，选择一种");
    }
    Validate.notBlank(ruleNodeParamsEntity.getTemplateParamName(), "添加信息时，对应的模板参数名不能为空！");
    Validate.notNull(ruleNodeParamsEntity.getParamType(), "添加信息时，参数类型不能为空！");
    Validate.notNull(ruleNodeParamsEntity.getNullable(), "添加信息时，参数是否可为null不能为空！");
    // 验证长度，被验证的这些字段符合特征: 字段类型为String，且不为PK （注意连续空字符串的情况） 
    Validate.isTrue(ruleNodeParamsEntity.getParamDesc() == null || ruleNodeParamsEntity.getParamDesc().length() < 512 , "参数中文说明,在进行添加时填入值超过了限定长度(512)，请检查!");
    Validate.isTrue(ruleNodeParamsEntity.getContextParamName() == null || ruleNodeParamsEntity.getContextParamName().length() < 128 , "上下文参数名,在进行添加时填入值超过了限定长度(128)，请检查!");
    Validate.isTrue(ruleNodeParamsEntity.getTemplateParamName() == null || ruleNodeParamsEntity.getTemplateParamName().length() < 128 , "模板参数名,在进行添加时填入值超过了限定长度(128)，请检查!");
  }
  @Transactional
  @Override
  public RuleNodeParamsEntity update(RuleNodeParamsEntity ruleNodeParamsEntity) { 
    RuleNodeParamsEntity current = this.updateForm(ruleNodeParamsEntity);
    //==================================================== 
    //    这里可以处理第三方系统调用（或特殊处理过程）
    //====================================================
    return current;
  } 
  @Transactional
  @Override
  public RuleNodeParamsEntity updateForm(RuleNodeParamsEntity ruleNodeParamsEntity) { 
    /* 
     * 针对1.1.3版本的需求，这个对静态模型的修改操作做出调整，新的过程为：
     * 1、如果当前模型对象不是主模型
     * 1.1、那么创建前只会验证基本信息，直接的ManyToOne关联（单选）和ManyToMany关联（多选）
     * 1.2、验证完成后，也只会保存当前对象的基本信息，直接的单选
     * TODO 1.3、ManyToMany的关联（多选），暂时需要开发人员自行处理（求删除、新增绑定的代码已生成）
     * 
     * 2、如果当前模型对象是主业务模型
     *  2.1、创建前会验证当前模型的基本属性，单选和多选属性
     *  2.2、然后还会验证当前模型关联的各个OneToMany明细信息，调用明细对象的服务，明每一条既有明细进行验证
     *  （2.2的步骤还需要注意，如果当前被验证的关联对象是回溯对象，则不需要验证了）
     *  2.3、还会验证当前模型关联的各个OneToOne分组，调用分组对象的服务，对分组中的信息进行验证
     *    2.3.1、包括验证每一个分组项的基本信息、直接的单选、多选信息
     *    2.3.2、以及验证每个分组的OneToMany明细信息
     * */
    
    this.updateValidation(ruleNodeParamsEntity);
    // ===================基本信息
    String currentId = ruleNodeParamsEntity.getId();
    Optional<RuleNodeParamsEntity> op_currentRuleNodeParamsEntity = this.ruleNodeParamsEntityRepository.findById(currentId);
    RuleNodeParamsEntity currentRuleNodeParamsEntity = op_currentRuleNodeParamsEntity.orElse(null);
    currentRuleNodeParamsEntity = Validate.notNull(currentRuleNodeParamsEntity ,"未发现指定的原始模型对象信");
    // 开始重新赋值——一般属性
    currentRuleNodeParamsEntity.setType(ruleNodeParamsEntity.getType());
    currentRuleNodeParamsEntity.setParamDesc(ruleNodeParamsEntity.getParamDesc());
    currentRuleNodeParamsEntity.setContextParamName(ruleNodeParamsEntity.getContextParamName());
    currentRuleNodeParamsEntity.setParamType(ruleNodeParamsEntity.getParamType());
    currentRuleNodeParamsEntity.setNullable(ruleNodeParamsEntity.getNullable());
    currentRuleNodeParamsEntity.setNode(ruleNodeParamsEntity.getNode());
    
    this.ruleNodeParamsEntityRepository.saveAndFlush(currentRuleNodeParamsEntity);
    return currentRuleNodeParamsEntity;
  }
  /**
   * 在更新一个已有的RuleNodeParamsEntity模型对象之前，该私有方法检查对象各属性的正确性，其id属性必须有值
   */
  private void updateValidation(RuleNodeParamsEntity ruleNodeParamsEntity) { 
    Validate.isTrue(!StringUtils.isBlank(ruleNodeParamsEntity.getId()), "修改信息时，当期信息的数据编号（主键）必须有值！");
    
    // 基础信息判断，基本属性，需要满足not null
    Validate.notNull(ruleNodeParamsEntity.getType(), "修改信息时，出参还是入参：1、入参；2、出参不能为空！");
    Validate.notBlank(ruleNodeParamsEntity.getParamDesc(), "修改信息时，参数中文说明不能为空！");
    String contextParamName = ruleNodeParamsEntity.getContextParamName();
    String fixedValue = ruleNodeParamsEntity.getFixedValue();
    if(StringUtils.isEmpty(contextParamName) && StringUtils.isEmpty(fixedValue)) {
      throw new IllegalArgumentException("修改信息时，入参来源必须从“固定值”/“上下文绑定”两种方式中，选择一种");
    }
    Validate.notBlank(ruleNodeParamsEntity.getTemplateParamName(), "修改信息时，对应的模板参数名不能为空！");
    Validate.notNull(ruleNodeParamsEntity.getParamType(), "修改信息时，参数类型不能为空！");
    Validate.notNull(ruleNodeParamsEntity.getNullable(), "修改信息时，参数是否可为null不能为空！");
    // 验证长度，被验证的这些字段符合特征: 字段类型为String，且不为PK，且canupdate = true
    Validate.isTrue(ruleNodeParamsEntity.getParamDesc() == null || ruleNodeParamsEntity.getParamDesc().length() < 512 , "参数中文说明,在进行修改时填入值超过了限定长度(512)，请检查!");
    Validate.isTrue(ruleNodeParamsEntity.getContextParamName() == null || ruleNodeParamsEntity.getContextParamName().length() < 128 , "上下文参数名,在进行修改时填入值超过了限定长度(128)，请检查!");
    
    // 关联性判断，关联属性判断，需要满足ManyToOne或者OneToOne，且not null 且是主模型
  } 
  @Override
  @Transactional
  public void deleteById(String id) {
    // 只有存在才进行删除
    Validate.notBlank(id , "进行删除时，必须给定主键信息!!");
    RuleNodeParamsEntity current = this.findById(id);
    if(current != null) { 
      this.ruleNodeParamsEntityRepository.delete(current);
    }
  }
  @Override
  @Transactional
  public void deleteByRuleNodes(String[] ruleNodeIds) {
    Validate.isTrue(ruleNodeIds != null && ruleNodeIds.length > 0 , "删除节点参数时，至少传入一个规则定义信息的编号");
    this.ruleNodeParamsEntityRepository.deleteByRuleNodes(ruleNodeIds);
    this.ruleNodeParamsEntityRepository.flush();
  }
  @Override
  public Set<RuleNodeParamsEntity> findDetailsByNode(String node) { 
    if(StringUtils.isBlank(node)) { 
      return Sets.newHashSet();
    }
    return this.ruleNodeParamsEntityRepository.findDetailsByNode(node);
  }
  @Override
  public RuleNodeParamsEntity findDetailsById(String id) { 
    if(StringUtils.isBlank(id)) { 
      return null;
    }
    return this.ruleNodeParamsEntityRepository.findDetailsById(id);
  }
  @Override
  public RuleNodeParamsEntity findById(String id) { 
    if(StringUtils.isBlank(id)) { 
      return null;
    }
    
    Optional<RuleNodeParamsEntity> op = ruleNodeParamsEntityRepository.findById(id);
    return op.orElse(null); 
  }
} 
