package com.bizunited.platform.mars.repository.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.persistence.EntityManager;
import javax.persistence.Query;

import com.bizunited.platform.common.util.ApplicationContextUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

import com.bizunited.platform.mars.entity.RuleDefinitionEntity;

@Repository("RuleDefinitionEntityRepositoryImpl")
public class RuleDefinitionEntityRepositoryImpl implements RuleDefinitionEntityRepositoryCustom {
  @Autowired
  private EntityManager entityManager;

  @SuppressWarnings("unchecked")
  @Override
  public Page<RuleDefinitionEntity> findByConditions(Pageable pageable, String code, String desc) {
    StringBuilder hql = new StringBuilder("select distinct rd from RuleDefinitionEntity rd where 1=1 ");
    StringBuilder countHql = new StringBuilder("select count(*) from RuleDefinitionEntity rd where 1 = 1 ");
    StringBuilder condition = new StringBuilder();
    Map<String, Object> parameters = new HashMap<>();
    // 筛选项目名称
    condition.append(" AND rd.projectName=:projectName ");
    parameters.put("projectName", ApplicationContextUtils.getProjectName());
    // 编码
    if(StringUtils.isNotBlank(code)) {
      condition.append(" AND rd.code = :code ");
      parameters.put("code", code);
    }
    // 规则定义说明（支持模糊）
    if(StringUtils.isNotBlank(desc)) {
      condition.append(" AND rd.desc like CONCAT('%',:desc,'%') ");
      parameters.put("desc", desc);
    }
    hql.append(condition);
    hql.append(" order by rd.cverion , rd.createTime ");
    countHql.append(condition);
    
    // 构造HQL查询 和 数量查询
    Query query = this.entityManager.createQuery(hql.toString());
    Query countQuery = this.entityManager.createQuery(countHql.toString());
    parameters.forEach((k, v) -> {
      query.setParameter(k, v);
      countQuery.setParameter(k, v);
    });
    // 构造分页信息
    query.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
    query.setMaxResults(pageable.getPageSize());
    List<RuleDefinitionEntity> resutls = query.getResultList();
    // 查询总数量信息
    long count = (long)countQuery.getResultList().get(0);
    return new PageImpl<>(resutls,pageable,count);
  }
}
