package com.bizunited.platform.mars.service;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.annotations.NebulaServiceMethod;
import com.bizunited.platform.core.annotations.NebulaServiceMethod.ScopeType;
import com.bizunited.platform.core.annotations.ServiceMethodParam;
import com.bizunited.platform.mars.entity.RuleDefinitionEntity;
import java.lang.String;
import java.util.List;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

/**
 * RuleDefinitionEntity业务模型的服务层接口定义
 * @author saturn
 */
public interface RuleDefinitionService { 
  /**
   * 针对一个新的规则定义，进行创建操作。注意：</br>
   * 创建操作时，规则定义的基本信息和附属信息，都不能包含ID信息，具体的信息结构可参见文档示例
   * @param definition 新的规则定义结构
   * @param layoutContent 前端布局文件内容信息
   * @return 如果该规则定义创建成功，则信息结构本身将被返回，并且这个信息的基本信息、附属信息中都将包括id属性
   */
  @NebulaServiceMethod(name="RuleDefinitionEntityService.create" , desc="创建一个新的RuleDefinitionEntity模型对象（包括了可能的第三方系统调用、复杂逻辑处理等）" , returnPropertiesFilter="" , scope=ScopeType.WRITE)
  public RuleDefinitionEntity create(RuleDefinitionEntity ruleDefinitionEntity , JSONObject layoutContent);
  /**
   * 针对一个已有的规则定义，进行该规则定义的全量修改。所谓全量修改，就是之前的规则定义信息会全部作废
   * @param definition 指定的规则定义，其中id信息必须有值
   * @param layoutContent 前端布局文件内容信息
   * @return 
   */
  @NebulaServiceMethod(name="RuleDefinitionEntityService.update" , desc="更新一个已有的RuleDefinitionEntity模型对象，其主键属性必须有值(1.1.4-release版本调整)。" , returnPropertiesFilter="", scope=ScopeType.WRITE)
  public RuleDefinitionEntity update(RuleDefinitionEntity ruleDefinitionEntity, JSONObject layoutContent);
  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   */
  @NebulaServiceMethod(name="RuleDefinitionEntityService.findDetailsById" , desc="按照主键进行详情查询（包括关联信息）" , returnPropertiesFilter="" , scope=ScopeType.READ)
  public RuleDefinitionEntity findDetailsById(@ServiceMethodParam(name="id") String id);
  /**
   * 按照版本和业务编号查询详情（包括关联信息）
   * @param code 指定的业务编号
   * @param cversion 指定的版本信息
   */
  public RuleDefinitionEntity findDetailsByCodeAndVersion(String code , String cversion);
  /**
   * 按照版本和业务编号查询详情
   * @param code 指定的业务编号
   * @param cversion 指定的版本信息
   * @return 
   */
  public RuleDefinitionEntity findByCodeAndVersion(String code , String cversion);
  /**
   * 按照RuleDefinitionEntity的主键编号，查询指定的数据信息（不包括任何关联信息）
   * @param id 主键
   * */
  public RuleDefinitionEntity findById(String id);
  /**
   * 查询当前已创建的所有规则定义基本信息，并按照创建时间进行排序
   * @return
   */
  public List<RuleDefinitionEntity> findAll();
  /**
   * 分页查询当前已建立的所有规则定义信息。
   * @param pageable 分页要求
   * @param code 规则定义编号
   * @param desc 规则定义描述
   */
  Page<RuleDefinitionEntity> findByConditions(Pageable pageable  , String code , String desc);
  /**
   *  按照主键进行信息的真删除 
   * @param id 主键 
   */
  public void deleteById(String id);

  /**
   * 按照给定的模板编码和版本，查询模板文件内容。
   * @param code
   * @param version
   * @return
   */
  String findContentByCodeAndVersion(String code, String version);
}