package com.bizunited.platform.mars.service.internal;
import com.bizunited.platform.core.annotations.NebulaServiceMethod;
import com.bizunited.platform.core.annotations.NebulaServiceMethod.ScopeType;
import com.bizunited.platform.core.annotations.ServiceMethodParam;
import com.bizunited.platform.mars.entity.RuleTimerNodeEntity;
import com.bizunited.platform.mars.repository.RuleTimerNodeEntityRepository;
import com.bizunited.platform.mars.service.RuleTimerNodeService;

import java.lang.Override;
import java.lang.String;
import java.util.Optional;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * RuleTimerNodeEntity业务模型的服务层接口实现
 * @author saturn
 */
@Service("RuleTimerNodeEntityServiceImpl")
public class RuleTimerNodeServiceImpl implements RuleTimerNodeService { 
  @Autowired
  private RuleTimerNodeEntityRepository ruleTimerNodeEntityRepository;
  @Transactional
  @Override
  public RuleTimerNodeEntity create(RuleTimerNodeEntity ruleTimerNodeEntity) { 
    RuleTimerNodeEntity current = this.createForm(ruleTimerNodeEntity);
    //==================================================== 
    //    这里可以处理第三方系统调用（或特殊处理过程）
    //====================================================
    return current;
  } 
  @Transactional
  @Override
  @NebulaServiceMethod(name="RuleTimerNodeEntityService.createForm" , desc="创建一个新的StudentEntity模型对象（默认不包括任何可能第三方系统调用、任何复杂逻辑处理等）" , returnPropertiesFilter="" , scope=ScopeType.WRITE)
  public RuleTimerNodeEntity createForm(RuleTimerNodeEntity ruleTimerNodeEntity) { 
    this.createValidation(ruleTimerNodeEntity);
    
    // ===============================
    //  和业务有关的验证填写在这个区域    
    // ===============================
    
    this.ruleTimerNodeEntityRepository.save(ruleTimerNodeEntity);
    // 返回最终处理的结果，里面带有详细的关联信息
    return ruleTimerNodeEntity;
  }
  /**
   * 在创建一个新的RuleTimerNodeEntity模型对象之前，检查对象各属性的正确性，其主键属性必须没有值
   */
  private void createValidation(RuleTimerNodeEntity ruleTimerNodeEntity) { 
    Validate.notNull(ruleTimerNodeEntity , "进行当前操作时，信息对象必须传入!!");
    // 判定那些不能为null的输入值：条件为 caninsert = true，且nullable = false
    Validate.isTrue(StringUtils.isBlank(ruleTimerNodeEntity.getId()), "添加信息时，当期信息的数据编号（主键）不能有值！");
    ruleTimerNodeEntity.setId(null);
    Validate.notNull(ruleTimerNodeEntity.getTimerCount(), "添加信息时，锁表达式不能为空！");
    Validate.notNull(ruleTimerNodeEntity.getTimeUnit(), "添加信息时，时间单位：1：秒；2：分；3：小时；4：天；其它值无效不能为空！");
    // 验证长度，被验证的这些字段符合特征: 字段类型为String，且不为PK （注意连续空字符串的情况） 
  }
  @Transactional
  @Override
  @NebulaServiceMethod(name="RuleTimerNodeEntityService.update" , desc="该方法只用于处理业务表单信息，包括了主业务模型、其下的关联模型、分组信息和明细细信息等" , returnPropertiesFilter="", scope=ScopeType.WRITE)
  public RuleTimerNodeEntity update(RuleTimerNodeEntity ruleTimerNodeEntity) { 
    RuleTimerNodeEntity current = this.updateForm(ruleTimerNodeEntity);
    //==================================================== 
    //    这里可以处理第三方系统调用（或特殊处理过程）
    //====================================================
    return current;
  } 
  @Transactional
  @Override
  public RuleTimerNodeEntity updateForm(RuleTimerNodeEntity ruleTimerNodeEntity) { 
    this.updateValidation(ruleTimerNodeEntity);
    // ===================基本信息
    String currentId = ruleTimerNodeEntity.getId();
    Optional<RuleTimerNodeEntity> op_currentRuleTimerNodeEntity = this.ruleTimerNodeEntityRepository.findById(currentId);
    RuleTimerNodeEntity currentRuleTimerNodeEntity = op_currentRuleTimerNodeEntity.orElse(null);
    currentRuleTimerNodeEntity = Validate.notNull(currentRuleTimerNodeEntity ,"未发现指定的原始模型对象信");
    // 开始重新赋值——一般属性
    currentRuleTimerNodeEntity.setTimerCount(ruleTimerNodeEntity.getTimerCount());
    currentRuleTimerNodeEntity.setTimeUnit(ruleTimerNodeEntity.getTimeUnit());
    
    this.ruleTimerNodeEntityRepository.saveAndFlush(currentRuleTimerNodeEntity);
    return currentRuleTimerNodeEntity;
  }
  /**
   * 在更新一个已有的RuleTimerNodeEntity模型对象之前，该私有方法检查对象各属性的正确性，其id属性必须有值
   */
  private void updateValidation(RuleTimerNodeEntity ruleTimerNodeEntity) { 
    Validate.isTrue(!StringUtils.isBlank(ruleTimerNodeEntity.getId()), "修改信息时，当期信息的数据编号（主键）必须有值！");
    
    // 基础信息判断，基本属性，需要满足not null
    Validate.notNull(ruleTimerNodeEntity.getTimerCount(), "修改信息时，锁表达式不能为空！");
    Validate.notNull(ruleTimerNodeEntity.getTimeUnit(), "修改信息时，时间单位：1：秒；2：分；3：小时；4：天；其它值无效不能为空！");
    // 验证长度，被验证的这些字段符合特征: 字段类型为String，且不为PK，且canupdate = true
  } 
  @Override
  @NebulaServiceMethod(name="RuleTimerNodeEntityService.findDetailsById" , desc="按照主键进行详情查询（包括关联信息）" , returnPropertiesFilter="" , scope=ScopeType.READ)
  public RuleTimerNodeEntity findDetailsById(@ServiceMethodParam(name="id") String id) {
    if(StringUtils.isBlank(id)) { 
      return null;
    }
    return this.ruleTimerNodeEntityRepository.findDetailsById(id);
  }
  @Override
  public RuleTimerNodeEntity findById(String id) { 
    if(StringUtils.isBlank(id)) { 
      return null;
    }
    
    Optional<RuleTimerNodeEntity> op = ruleTimerNodeEntityRepository.findById(id);
    return op.orElse(null); 
  }
  @Override
  @Transactional
  public void deleteById(String id) {
    // 只有存在才进行删除
    Validate.notBlank(id , "进行删除时，必须给定主键信息!!");
    RuleTimerNodeEntity current = this.findById(id);
    if(current != null) { 
      this.ruleTimerNodeEntityRepository.delete(current);
    }
  }
  @Override
  @Transactional
  public void deleteByIds(String[] ids) {
    Validate.notNull(ids , "进行删除时，必须给定主键信息(支持多个)!!");
    for (String id : ids) {
      this.deleteById(id);
    }
  }
} 
