/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.mars.service.init;

import com.bizunited.platform.common.constant.PlatformContext;
import com.bizunited.platform.common.service.init.InitProcessService;
import com.bizunited.platform.mars.entity.RuleTemplateNodeEntity;
import com.bizunited.platform.mars.entity.RuleTemplateParamsEntity;
import com.bizunited.platform.mars.service.RuleTemplateNodeService;
import com.bizunited.platform.mars.service.RuleTemplateParamsService;
import java.util.Date;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="RuleTemplateNodeInitProcessService")
public class RuleTemplateNodeInitProcessService
implements InitProcessService {
    @Autowired
    private RuleTemplateNodeService ruleTemplateNodeService;
    @Autowired
    private RuleTemplateParamsService ruleTemplateParamsService;
    @Autowired
    private PlatformContext platformContext;
    private static final String START_TEMPLATE_CODE = "defaultStart";
    private static final String END_TEMPLATE_CODE = "defaultEnd";
    private static final String CONDITION_TEMPLATE_CODE = "defaultCondition";
    private static final String DYNAMIC_SCRIPT_TEMPLATE_CODE = "dynamicScript";
    private static final String TIMER_CODE = "defaultTimer";
    private static final String CONCURRENT_AGGREGATION = "defaultConcurrentAggregation";
    private static final String PARALLEL_BRANCH = "defaultParallelBranch";

    public boolean doProcess() {
        RuleTemplateNodeEntity defaultStart = this.ruleTemplateNodeService.findByCode(START_TEMPLATE_CODE);
        RuleTemplateNodeEntity defaultEnd = this.ruleTemplateNodeService.findByCode(END_TEMPLATE_CODE);
        RuleTemplateNodeEntity defaultCondition = this.ruleTemplateNodeService.findByCode(CONDITION_TEMPLATE_CODE);
        RuleTemplateNodeEntity dynamicScript = this.ruleTemplateNodeService.findByCode(DYNAMIC_SCRIPT_TEMPLATE_CODE);
        Set<RuleTemplateParamsEntity> paramsEntities = null;
        if (dynamicScript != null) {
            paramsEntities = this.ruleTemplateParamsService.findDetailsByTemplateNode(dynamicScript.getId());
        }
        RuleTemplateNodeEntity timerCode = this.ruleTemplateNodeService.findByCode(TIMER_CODE);
        RuleTemplateNodeEntity concurrentAggregation = this.ruleTemplateNodeService.findByCode(CONCURRENT_AGGREGATION);
        RuleTemplateNodeEntity parallelBranch = this.ruleTemplateNodeService.findByCode(PARALLEL_BRANCH);
        return defaultStart == null || defaultEnd == null || defaultCondition == null || dynamicScript == null || dynamicScript != null && CollectionUtils.isEmpty(paramsEntities) || timerCode == null || concurrentAggregation == null || parallelBranch == null;
    }

    @Transactional
    public void init() {
        RuleTemplateNodeEntity parallelBranch;
        RuleTemplateNodeEntity concurrentAggregation;
        RuleTemplateNodeEntity dynamicScript;
        RuleTemplateNodeEntity defaultCondition;
        RuleTemplateNodeEntity defaultEnd;
        RuleTemplateNodeEntity defaultStart = this.ruleTemplateNodeService.findByCode(START_TEMPLATE_CODE);
        if (defaultStart == null) {
            this.initDefaultStart();
        }
        if ((defaultEnd = this.ruleTemplateNodeService.findByCode(END_TEMPLATE_CODE)) == null) {
            this.initDefaultEnd();
        }
        if ((defaultCondition = this.ruleTemplateNodeService.findByCode(CONDITION_TEMPLATE_CODE)) == null) {
            this.initDefaultCondition();
        }
        if ((dynamicScript = this.ruleTemplateNodeService.findByCode(DYNAMIC_SCRIPT_TEMPLATE_CODE)) == null) {
            this.initDefaultDynamicScript();
        } else {
            Set<RuleTemplateParamsEntity> paramsEntities = this.ruleTemplateParamsService.findDetailsByTemplateNode(dynamicScript.getId());
            if (CollectionUtils.isEmpty(paramsEntities)) {
                this.initDefaultDynamicScriptParams(dynamicScript);
            }
        }
        RuleTemplateNodeEntity timerCode = this.ruleTemplateNodeService.findByCode(TIMER_CODE);
        if (timerCode == null) {
            this.initDefaultTimer();
        }
        if ((concurrentAggregation = this.ruleTemplateNodeService.findByCode(CONCURRENT_AGGREGATION)) == null) {
            this.initDefaultConcurrentAggregation();
        }
        if ((parallelBranch = this.ruleTemplateNodeService.findByCode(PARALLEL_BRANCH)) == null) {
            this.initDefaultParallelBranch();
        }
    }

    private void initDefaultStart() {
        Date currentTime = new Date();
        RuleTemplateNodeEntity ruleTemplateNode = new RuleTemplateNodeEntity();
        ruleTemplateNode.setCode(START_TEMPLATE_CODE);
        ruleTemplateNode.setName("\u9ed8\u8ba4\u5f00\u59cb");
        ruleTemplateNode.setCreateAccount("admin");
        ruleTemplateNode.setCreateTime(currentTime);
        ruleTemplateNode.setModifyAccount("admin");
        ruleTemplateNode.setModifyTime(currentTime);
        ruleTemplateNode.setNodeStatus(1);
        ruleTemplateNode.setType(4);
        ruleTemplateNode.setProjectName(this.platformContext.getAppName());
        this.ruleTemplateNodeService.create(ruleTemplateNode);
    }

    private void initDefaultEnd() {
        Date currentTime = new Date();
        RuleTemplateNodeEntity ruleTemplateNode = new RuleTemplateNodeEntity();
        ruleTemplateNode.setCode(END_TEMPLATE_CODE);
        ruleTemplateNode.setName("\u9ed8\u8ba4\u7ed3\u675f");
        ruleTemplateNode.setCreateAccount("admin");
        ruleTemplateNode.setCreateTime(currentTime);
        ruleTemplateNode.setModifyAccount("admin");
        ruleTemplateNode.setModifyTime(currentTime);
        ruleTemplateNode.setNodeStatus(1);
        ruleTemplateNode.setType(5);
        ruleTemplateNode.setProjectName(this.platformContext.getAppName());
        this.ruleTemplateNodeService.create(ruleTemplateNode);
    }

    private void initDefaultCondition() {
        Date currentTime = new Date();
        RuleTemplateNodeEntity ruleTemplateNode = new RuleTemplateNodeEntity();
        ruleTemplateNode.setCode(CONDITION_TEMPLATE_CODE);
        ruleTemplateNode.setName("\u9ed8\u8ba4\u6761\u4ef6");
        ruleTemplateNode.setCreateAccount("admin");
        ruleTemplateNode.setCreateTime(currentTime);
        ruleTemplateNode.setModifyAccount("admin");
        ruleTemplateNode.setModifyTime(currentTime);
        ruleTemplateNode.setNodeStatus(1);
        ruleTemplateNode.setType(1);
        ruleTemplateNode.setProjectName(this.platformContext.getAppName());
        this.ruleTemplateNodeService.create(ruleTemplateNode);
    }

    private void initDefaultDynamicScript() {
        Date currentTime = new Date();
        RuleTemplateNodeEntity ruleTemplateNode = new RuleTemplateNodeEntity();
        ruleTemplateNode.setCode(DYNAMIC_SCRIPT_TEMPLATE_CODE);
        ruleTemplateNode.setName("\u9ed8\u8ba4\u52a8\u6001\u811a\u672c\u903b\u8f91");
        ruleTemplateNode.setCreateAccount("admin");
        ruleTemplateNode.setCreateTime(currentTime);
        ruleTemplateNode.setModifyAccount("admin");
        ruleTemplateNode.setModifyTime(currentTime);
        ruleTemplateNode.setNodeStatus(1);
        ruleTemplateNode.setType(2);
        ruleTemplateNode.setSourceType(5);
        ruleTemplateNode.setProjectName(this.platformContext.getAppName());
        this.ruleTemplateNodeService.create(ruleTemplateNode);
        this.initDefaultDynamicScriptParams(ruleTemplateNode);
    }

    private void initDefaultDynamicScriptParams(RuleTemplateNodeEntity ruleTemplateNode) {
        RuleTemplateParamsEntity inputRuleTemplateParams = new RuleTemplateParamsEntity();
        inputRuleTemplateParams.setParamName("_script");
        inputRuleTemplateParams.setType(1);
        inputRuleTemplateParams.setNullable(false);
        inputRuleTemplateParams.setParamType("string");
        inputRuleTemplateParams.setParamDesc("\u52a8\u6001\u811a\u672c");
        inputRuleTemplateParams.setTemplateNode(ruleTemplateNode);
        this.ruleTemplateParamsService.create(inputRuleTemplateParams);
        RuleTemplateParamsEntity outputRuleTemplateParams = new RuleTemplateParamsEntity();
        outputRuleTemplateParams.setParamName("_result");
        outputRuleTemplateParams.setType(2);
        outputRuleTemplateParams.setNullable(true);
        outputRuleTemplateParams.setParamType("object");
        outputRuleTemplateParams.setParamDesc("\u52a8\u6001\u811a\u672c\u51fa\u53c2");
        outputRuleTemplateParams.setTemplateNode(ruleTemplateNode);
        this.ruleTemplateParamsService.create(outputRuleTemplateParams);
    }

    private void initDefaultTimer() {
        Date currentTime = new Date();
        RuleTemplateNodeEntity ruleTemplateNode = new RuleTemplateNodeEntity();
        ruleTemplateNode.setCode(TIMER_CODE);
        ruleTemplateNode.setName("\u9ed8\u8ba4\u5ef6\u8fdf\u7b49\u5f85\u8282\u70b9");
        ruleTemplateNode.setCreateAccount("admin");
        ruleTemplateNode.setCreateTime(currentTime);
        ruleTemplateNode.setModifyAccount("admin");
        ruleTemplateNode.setModifyTime(currentTime);
        ruleTemplateNode.setNodeStatus(1);
        ruleTemplateNode.setType(8);
        ruleTemplateNode.setProjectName(this.platformContext.getAppName());
        this.ruleTemplateNodeService.create(ruleTemplateNode);
    }

    private void initDefaultConcurrentAggregation() {
        Date currentTime = new Date();
        RuleTemplateNodeEntity ruleTemplateNode = new RuleTemplateNodeEntity();
        ruleTemplateNode.setCode(CONCURRENT_AGGREGATION);
        ruleTemplateNode.setName("\u9ed8\u8ba4\u5e76\u53d1\u6c47\u805a\u8282\u70b9");
        ruleTemplateNode.setCreateAccount("admin");
        ruleTemplateNode.setCreateTime(currentTime);
        ruleTemplateNode.setModifyAccount("admin");
        ruleTemplateNode.setModifyTime(currentTime);
        ruleTemplateNode.setNodeStatus(1);
        ruleTemplateNode.setType(7);
        ruleTemplateNode.setProjectName(this.platformContext.getAppName());
        this.ruleTemplateNodeService.create(ruleTemplateNode);
    }

    private void initDefaultParallelBranch() {
        Date currentTime = new Date();
        RuleTemplateNodeEntity ruleTemplateNode = new RuleTemplateNodeEntity();
        ruleTemplateNode.setCode(PARALLEL_BRANCH);
        ruleTemplateNode.setName("\u9ed8\u8ba4A/B\u5e76\u884c\u5206\u652f\u8282\u70b9");
        ruleTemplateNode.setCreateAccount("admin");
        ruleTemplateNode.setCreateTime(currentTime);
        ruleTemplateNode.setModifyAccount("admin");
        ruleTemplateNode.setModifyTime(currentTime);
        ruleTemplateNode.setNodeStatus(1);
        ruleTemplateNode.setType(6);
        ruleTemplateNode.setProjectName(this.platformContext.getAppName());
        this.ruleTemplateNodeService.create(ruleTemplateNode);
    }
}

