/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.mars.service.internal;

import com.bizunited.platform.mars.entity.RuleTemplateParamsEntity;
import com.bizunited.platform.mars.repository.RuleTemplateParamsEntityRepository;
import com.bizunited.platform.mars.service.RuleTemplateParamsService;
import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="RuleTemplateParamsEntityServiceImpl")
public class RuleTemplateParamsServiceImpl
implements RuleTemplateParamsService {
    @Autowired
    private RuleTemplateParamsEntityRepository ruleTemplateParamsEntityRepository;

    @Override
    @Transactional
    public RuleTemplateParamsEntity create(RuleTemplateParamsEntity ruleTemplateParamsEntity) {
        RuleTemplateParamsEntity current = this.createForm(ruleTemplateParamsEntity);
        return current;
    }

    @Override
    @Transactional
    public RuleTemplateParamsEntity createForm(RuleTemplateParamsEntity ruleTemplateParamsEntity) {
        this.createValidation(ruleTemplateParamsEntity);
        this.ruleTemplateParamsEntityRepository.save((Object)ruleTemplateParamsEntity);
        return ruleTemplateParamsEntity;
    }

    private void createValidation(RuleTemplateParamsEntity ruleTemplateParamsEntity) {
        Validate.notNull((Object)((Object)ruleTemplateParamsEntity), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)ruleTemplateParamsEntity.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        ruleTemplateParamsEntity.setId(null);
        Validate.notNull((Object)ruleTemplateParamsEntity.getType(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u51fa\u53c2\u8fd8\u662f\u5165\u53c2\uff1a1\u3001\u5165\u53c2\uff1b2\u3001\u51fa\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)ruleTemplateParamsEntity.getParamDesc(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u53c2\u6570\u4e2d\u6587\u8bf4\u660e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)ruleTemplateParamsEntity.getParamName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u53c2\u6570\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)ruleTemplateParamsEntity.getParamType(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u53c2\u6570\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)ruleTemplateParamsEntity.getNullable(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u53c2\u6570\u662f\u5426\u53ef\u4e3anull\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((ruleTemplateParamsEntity.getParamDesc() == null || ruleTemplateParamsEntity.getParamDesc().length() < 512 ? 1 : 0) != 0, (String)"\u53c2\u6570\u4e2d\u6587\u8bf4\u660e,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(512)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((ruleTemplateParamsEntity.getParamName() == null || ruleTemplateParamsEntity.getParamName().length() < 128 ? 1 : 0) != 0, (String)"\u53c2\u6570\u540d,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public RuleTemplateParamsEntity update(RuleTemplateParamsEntity ruleTemplateParamsEntity) {
        RuleTemplateParamsEntity current = this.updateForm(ruleTemplateParamsEntity);
        return current;
    }

    @Override
    @Transactional
    public RuleTemplateParamsEntity updateForm(RuleTemplateParamsEntity ruleTemplateParamsEntity) {
        this.updateValidation(ruleTemplateParamsEntity);
        String currentId = ruleTemplateParamsEntity.getId();
        Optional op_currentRuleTemplateParamsEntity = this.ruleTemplateParamsEntityRepository.findById(currentId);
        RuleTemplateParamsEntity currentRuleTemplateParamsEntity = op_currentRuleTemplateParamsEntity.orElse(null);
        currentRuleTemplateParamsEntity = (RuleTemplateParamsEntity)((Object)Validate.notNull((Object)((Object)currentRuleTemplateParamsEntity), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]));
        currentRuleTemplateParamsEntity.setType(ruleTemplateParamsEntity.getType());
        currentRuleTemplateParamsEntity.setParamDesc(ruleTemplateParamsEntity.getParamDesc());
        currentRuleTemplateParamsEntity.setParamName(ruleTemplateParamsEntity.getParamName());
        currentRuleTemplateParamsEntity.setParamType(ruleTemplateParamsEntity.getParamType());
        currentRuleTemplateParamsEntity.setNullable(ruleTemplateParamsEntity.getNullable());
        currentRuleTemplateParamsEntity.setTemplateNode(ruleTemplateParamsEntity.getTemplateNode());
        this.ruleTemplateParamsEntityRepository.saveAndFlush((Object)currentRuleTemplateParamsEntity);
        return currentRuleTemplateParamsEntity;
    }

    private void updateValidation(RuleTemplateParamsEntity ruleTemplateParamsEntity) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)ruleTemplateParamsEntity.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)ruleTemplateParamsEntity.getType(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u51fa\u53c2\u8fd8\u662f\u5165\u53c2\uff1a1\u3001\u5165\u53c2\uff1b2\u3001\u51fa\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)ruleTemplateParamsEntity.getParamDesc(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u53c2\u6570\u4e2d\u6587\u8bf4\u660e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)ruleTemplateParamsEntity.getParamName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u53c2\u6570\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)ruleTemplateParamsEntity.getParamType(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u53c2\u6570\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)ruleTemplateParamsEntity.getNullable(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u53c2\u6570\u662f\u5426\u53ef\u4e3anull\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((ruleTemplateParamsEntity.getParamDesc() == null || ruleTemplateParamsEntity.getParamDesc().length() < 512 ? 1 : 0) != 0, (String)"\u53c2\u6570\u4e2d\u6587\u8bf4\u660e,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(512)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((ruleTemplateParamsEntity.getParamName() == null || ruleTemplateParamsEntity.getParamName().length() < 128 ? 1 : 0) != 0, (String)"\u53c2\u6570\u540d,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    public Set<RuleTemplateParamsEntity> findDetailsByTemplateNode(String templateNode) {
        if (StringUtils.isBlank((CharSequence)templateNode)) {
            return Sets.newHashSet();
        }
        return this.ruleTemplateParamsEntityRepository.findDetailsByTemplateNode(templateNode);
    }

    @Override
    public RuleTemplateParamsEntity findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.ruleTemplateParamsEntityRepository.findDetailsById(id);
    }

    @Override
    public RuleTemplateParamsEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.ruleTemplateParamsEntityRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        RuleTemplateParamsEntity current = this.findById(id);
        if (current != null) {
            this.ruleTemplateParamsEntityRepository.delete((Object)current);
        }
    }

    @Override
    @Transactional
    public void deleteByTemplateNode(String templateNodeId) {
        Validate.notBlank((CharSequence)templateNodeId, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u6a21\u677f\u7f16\u53f7\u4fe1\u606f!!", (Object[])new Object[0]);
        this.ruleTemplateParamsEntityRepository.deleteByTemplateNode(templateNodeId);
    }
}

