/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.mars.local.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.mars.entity.RuleDefinitionEntity;
import com.bizunited.platform.mars.service.RuleDefinitionService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/mars/ruleDefinitions"})
public class RuleDefinitionController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(RuleDefinitionController.class);
    @Autowired
    private RuleDefinitionService ruleDefinitionEntityService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @ApiOperation(value="\u9488\u5bf9\u4e00\u4e2a\u65b0\u7684\u89c4\u5219\u5b9a\u4e49\uff0c\u8fdb\u884c\u521b\u5efa\u64cd\u4f5c\u3002\u6ce8\u610f\uff1a\u521b\u5efa\u64cd\u4f5c\u65f6\uff0c\u89c4\u5219\u5b9a\u4e49\u7684\u57fa\u672c\u4fe1\u606f\u548c\u9644\u5c5e\u4fe1\u606f\uff0c\u90fd\u4e0d\u80fd\u5305\u542bID\u4fe1\u606f\uff0c\u5177\u4f53\u7684\u4fe1\u606f\u7ed3\u6784\u53ef\u53c2\u89c1\u6587\u6863\u793a\u4f8b")
    @PostMapping(value={""})
    public ResponseModel create(@RequestParam(value="runtimeDefinition") @ApiParam(name="runtimeDefinition", value="\u7b26\u5408\u524d\u540e\u7aef\u89c4\u5219\u5b9a\u4e49\u6570\u636e\u7ed3\u6784\u63cf\u8ff0\u7684json\u4fe1\u606f") String runtimeDefinitionJson, @RequestParam(value="layoutContent") @ApiParam(name="layoutContent", value="\u524d\u7aef\u5e03\u5c40\u6587\u4ef6\u6392\u7248\u4fe1\u606f") String layoutContent, HttpServletRequest request) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Enumeration names = request.getParameterNames();
        if (names != null) {
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if ("runtimeDefinition".equals(name) || "layoutContent".equals(name)) continue;
                String[] values = request.getParameterValues(name);
                if (values != null && values.length == 1) {
                    params.put(name, values[0]);
                    continue;
                }
                if (values == null || values.length <= 1) continue;
                params.put(name, values);
            }
        }
        try {
            JSONObject jsonObject = JSON.parseObject((String)runtimeDefinitionJson);
            RuleDefinitionEntity definition = (RuleDefinitionEntity)JSON.toJavaObject((JSON)jsonObject, RuleDefinitionEntity.class);
            definition = this.ruleDefinitionEntityService.create(definition, JSONObject.parseObject((String)layoutContent), params);
            return this.buildHttpResultW(definition, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u9488\u5bf9\u4e00\u4e2a\u5df2\u6709\u7684\u89c4\u5219\u5b9a\u4e49\uff0c\u8fdb\u884c\u8be5\u89c4\u5219\u5b9a\u4e49\u7684\u5168\u91cf\u4fee\u6539\u3002\u6240\u8c13\u5168\u91cf\u4fee\u6539\uff0c\u5c31\u662f\u4e4b\u524d\u7684\u89c4\u5219\u5b9a\u4e49\u4fe1\u606f\u4f1a\u5168\u90e8\u4f5c\u5e9f")
    @PatchMapping(value={""})
    public ResponseModel update(@RequestParam(value="runtimeDefinition") @ApiParam(name="runtimeDefinition", value="\u7b26\u5408\u524d\u540e\u7aef\u89c4\u5219\u5b9a\u4e49\u6570\u636e\u7ed3\u6784\u63cf\u8ff0\u7684json\u4fe1\u606f") String runtimeDefinitionJson, @RequestParam(value="layoutContent") @ApiParam(name="layoutContent", value="\u524d\u7aef\u5e03\u5c40\u6587\u4ef6\u6392\u7248\u4fe1\u606f") String layoutContent, HttpServletRequest request) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Enumeration names = request.getParameterNames();
        if (names != null) {
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if ("runtimeDefinition".equals(name) || "layoutContent".equals(name)) continue;
                String[] values = request.getParameterValues(name);
                if (values != null && values.length == 1) {
                    params.put(name, values[0]);
                    continue;
                }
                if (values == null || values.length <= 1) continue;
                params.put(name, values);
            }
        }
        try {
            RuleDefinitionEntity definition = (RuleDefinitionEntity)JSON.toJavaObject((JSON)JSON.parseObject((String)runtimeDefinitionJson), RuleDefinitionEntity.class);
            definition = this.ruleDefinitionEntityService.update(definition, JSONObject.parseObject((String)layoutContent), params);
            return this.buildHttpResultW(definition, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u7ed9\u5b9a\u7684\u89c4\u5219\u5b9a\u4e49\u7f16\u53f7\u548c\u7248\u672c\u4fe1\u606f\uff0c\u67e5\u8be2\u5b8c\u6574\u7684\u89c4\u5219\u63cf\u8ff0\u3002\u89c4\u5219\u63cf\u8ff0\u4fe1\u606f\u5c06\u57fa\u4e8e\u6301\u4e45\u5c42\u5b58\u50a8\u7684\u89c4\u5219\u5b9a\u4e49")
    @RequestMapping(value={"/findDetailsByCodeAndVersion"}, method={RequestMethod.GET})
    public ResponseModel findDetailsByCodeAndVersion(@RequestParam(value="code") @ApiParam(name="code", value="\u524d\u7aef\u5e03\u5c40\u6587\u4ef6\u6392\u7248\u4fe1\u606f") String code, @RequestParam(value="version") @ApiParam(name="version", value="\u524d\u7aef\u5e03\u5c40\u6587\u4ef6\u6392\u7248\u4fe1\u606f") String version) {
        try {
            RuleDefinitionEntity result = this.ruleDefinitionEntityService.findDetailsByCodeAndVersion(code, version);
            RuleDefinitionEntity target = (RuleDefinitionEntity)this.nebulaToolkitService.copyObjectByWhiteList((Object)result, RuleDefinitionEntity.class, LinkedHashSet.class, ArrayList.class, new String[]{"nodes", "nodes.templateNode", "nodes.ruleLockExt", "nodes.ruleAggregationExt", "nodes.ruleTimerExt", "nodes.inputs", "nodes.outputs", "nodes.nexts", "nodes.nexts.fromNode", "nodes.nexts.toNode"});
            return this.buildHttpResult(target);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u7ed9\u5b9a\u7684\u6a21\u677f\u7f16\u7801\u548c\u7248\u672c\uff0c\u67e5\u8be2\u6a21\u677f\u6587\u4ef6\u5185\u5bb9\u3002")
    @GetMapping(value={"/findContentByCodeAndVersion"})
    public ResponseModel findContentByCodeAndVersion(@ApiParam(name="code", value="\u6a21\u677f\u7f16\u7801", required=true) @RequestParam(value="code") String code, @ApiParam(name="version", value="\u7248\u672c", required=true) @RequestParam(value="version") String version) {
        try {
            String content = this.ruleDefinitionEntityService.findContentByCodeAndVersion(code, version);
            return this.buildHttpResultW(content, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5f53\u524d\u5df2\u5efa\u7acb\u7684\u6240\u6709\u89c4\u5219\u5b9a\u4e49\u4fe1\u606f")
    @RequestMapping(value={"/findByConditions"}, method={RequestMethod.GET})
    public ResponseModel findByConditions(@PageableDefault(value=50) @ApiParam(name="pageable", value="\u5206\u9875\u53c2\u6570\uff0c\u5f53\u6307\u5b9apage\u65f6\u4e3a\u67e5\u8be2\u5f53\u524d\u9875\u7801\uff08\u9875\u7801\u4ece0\u5f00\u59cb\uff09\uff1b\u5f53\u6307\u5b9asize\u65f6\uff0c\u4e3a\u6307\u5b9a\u6bcf\u9875\u5927\u5c0f\uff0c\u9ed8\u8ba4\u4e3a50") Pageable pageable, @RequestParam(name="code", required=false) @ApiParam(value="\u89c4\u5219\u5b9a\u4e49\u7f16\u53f7\uff08\u53ef\u4ee5\u4e0d\u4f20\u5165\uff09", required=false) String code, @RequestParam(name="desc", required=false) @ApiParam(value="\u89c4\u5219\u5b9a\u4e49\u63cf\u8ff0\uff08\u53ef\u4ee5\u4e0d\u4f20\u5165\uff09", required=false) String desc) {
        try {
            Page result = this.ruleDefinitionEntityService.findByConditions(pageable, code, desc);
            return this.buildHttpResultW(result, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u5df2\u521b\u5efa\u7684\u6240\u6709\u89c4\u5219\u5b9a\u4e49\u57fa\u672c\u4fe1\u606f\uff0c\u5e76\u6309\u7167\u521b\u5efa\u65f6\u95f4\u8fdb\u884c\u6392\u5e8f")
    @GetMapping(value={"/findAll"})
    public ResponseModel findAll() {
        try {
            List result = this.ruleDefinitionEntityService.findAll();
            return this.buildHttpResultW(result, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u7248\u672c\u5347\u7ea7")
    @PostMapping(value={"/updateVersion"})
    public ResponseModel updateVersion(@RequestParam(value="runtimeDefinition") @ApiParam(name="runtimeDefinition", value="\u7b26\u5408\u524d\u540e\u7aef\u89c4\u5219\u5b9a\u4e49\u6570\u636e\u7ed3\u6784\u63cf\u8ff0\u7684json\u4fe1\u606f") String runtimeDefinitionJson, @RequestParam(value="layoutContent") @ApiParam(name="layoutContent", value="\u524d\u7aef\u5e03\u5c40\u6587\u4ef6\u6392\u7248\u4fe1\u606f") String layoutContent, @RequestParam(value="newVersion") String newVersion) {
        try {
            JSONObject jsonObject = JSON.parseObject((String)runtimeDefinitionJson);
            RuleDefinitionEntity definition = (RuleDefinitionEntity)JSON.toJavaObject((JSON)jsonObject, RuleDefinitionEntity.class);
            definition = this.ruleDefinitionEntityService.updateVersion(definition, newVersion, JSONObject.parseObject((String)layoutContent));
            return this.buildHttpResultW(definition, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

