package com.bizunited.platform.mars.policy.process.runtime.service;

import org.springframework.stereotype.Component;

import com.bizunited.platform.mars.policy.process.cache.RuntimeNode;
import com.bizunited.platform.mars.policy.process.cache.RuntimeProcessorLinked;
import com.bizunited.platform.mars.policy.process.cache.RuntimeProcessorLinked.Status;
import com.bizunited.platform.mars.policy.process.runtime.contexts.RuleRuntimeContext;

/**
 * 规则执行链路服务的实现
 * @author yinwenjie
 */
@Component("simpleRuntimeProcessorLinkedService")
public class SimpleRuntimeProcessorLinkedService implements RuntimeProcessorLinkedService {
  
  @Override
  public void start(RuleRuntimeContext context, RuntimeProcessorLinked runtimeProcessorLinked) {
    /*
     * 规律链路开始时，需要做以下记录：
     * 1、将当前链路加入到上下文中
     * 2、修改当前规则链路的状态为运行中
     * */
    context.addRuntimeProcessorLinkeds(runtimeProcessorLinked);
    runtimeProcessorLinked.setStatus(Status.RUNNABLE);
  }

  @Override
  public void end(RuntimeProcessorLinked runtimeProcessorLinked, RuntimeNode runtimeNode) {
    /*
     * 将当前运行时节点加入到链路定义中
     * */
    runtimeProcessorLinked.addRuntimeNode(runtimeNode);
    runtimeProcessorLinked.setCurrentNode(runtimeNode);
    runtimeProcessorLinked.setTerminator(runtimeNode);
    runtimeProcessorLinked.setStatus(Status.DONE);
  }

  @Override
  public void exception(RuntimeProcessorLinked runtimeProcessorLinked, RuntimeNode runtimeNode, Throwable throwable) {
    runtimeProcessorLinked.setExceptioner(runtimeNode);
    runtimeProcessorLinked.setThrowable(throwable);
    runtimeProcessorLinked.setCurrentNode(runtimeNode);
    runtimeProcessorLinked.setStatus(Status.EXCEPTION);
  }

  @Override
  public void next(RuntimeProcessorLinked runtimeProcessorLinked, RuntimeNode runtimeNode) {
    runtimeProcessorLinked.setCurrentNode(runtimeNode);
    runtimeProcessorLinked.addRuntimeNode(runtimeNode);
    runtimeProcessorLinked.setStatus(Status.RUNNABLE);
  }
}
