/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.mars.policy.process.rule.logic;

import com.bizunited.platform.core.entity.DataViewEntity;
import com.bizunited.platform.core.service.dataview.DataViewService;
import com.bizunited.platform.core.service.dataview.model.ExecuteParamModel;
import com.bizunited.platform.mars.policy.process.cache.RuntimeNodeParams;
import com.bizunited.platform.mars.policy.process.cache.RuntimeProcessorLinked;
import com.bizunited.platform.mars.policy.process.cache.logic.RuntimeDataViewNode;
import com.bizunited.platform.mars.policy.process.executor.ProcessorChain;
import com.bizunited.platform.mars.policy.process.rule.logic.AbstractLogicRuleable;
import com.bizunited.platform.mars.policy.process.rule.logic.LogicRuleable;
import com.bizunited.platform.mars.policy.process.runtime.contexts.RuleRuntimeContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="dataviewProcessRuleable")
public class DataviewProcessRuleable<T extends RuntimeDataViewNode>
extends AbstractLogicRuleable<RuntimeDataViewNode>
implements LogicRuleable<RuntimeDataViewNode> {
    @Autowired
    private DataViewService dataViewService;

    @Override
    public void doProcess(RuntimeDataViewNode currentNode, RuleRuntimeContext context, RuntimeProcessorLinked runtimeProcessorLinked, ProcessorChain processChain) {
        super.process(currentNode, runtimeProcessorLinked);
        processChain.doProcessNode(context, runtimeProcessorLinked);
    }

    @Override
    protected void execute(RuntimeDataViewNode currentNode, Map<String, Object> inputParamValues, RuleRuntimeContext context) {
        Set<RuntimeNodeParams> outputParams;
        String viewCode = currentNode.getViewCode();
        Validate.notNull((Object)viewCode, (String)"\u5728\u57fa\u4e8e\u6570\u636e\u89c6\u56fe\u7684\u6761\u4ef6\u5224\u5b9a\u5904\u7406\u5668\u5de5\u4f5c\u65f6\uff0c\u672a\u53d1\u73b0\u6307\u5b9a\u7684codeView\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e", (Object[])new Object[0]);
        DataViewEntity currentDataView = this.dataViewService.findDetailsByCode(viewCode);
        Validate.notNull((Object)currentDataView, (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u6570\u636e\u89c6\u56fe\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{viewCode});
        ExecuteParamModel dataViewParamModel = new ExecuteParamModel();
        dataViewParamModel.setSystemParams(inputParamValues);
        dataViewParamModel.setDataViewCode(currentDataView.getCode());
        if (currentDataView.getDataSource() != null) {
            dataViewParamModel.setDataSourceCode(currentDataView.getDataSource().getCode());
        }
        Validate.isTrue(((outputParams = currentNode.getOutputs()) == null || outputParams != null && outputParams.size() == 1 ? 1 : 0) != 0, (String)"\u8fd0\u884c\u8282\u70b9[%s]\u65f6\uff0c\u53d1\u73b0\u5176\u8bbe\u5b9a\u7684\u51fa\u53c2\u4e0d\u7b26\u5408\u8981\u6c42(\u8981\u4e48\u4e0d\u8bbe\u5b9a\u8fd4\u56de\u503c\uff0c\u8981\u4e48\u53ea\u8bbe\u7f6e\u4e00\u4e2a\u8fd4\u56de\u503c\u53c2\u6570)!!", (Object[])new Object[0]);
        if (outputParams == null) {
            return;
        }
        RuntimeNodeParams outputParam = outputParams.iterator().next();
        String contextParamName = outputParam.getContextParamName();
        ExecuteParamModel executeParamModel = new ExecuteParamModel();
        executeParamModel.setDataViewCode(currentNode.getViewCode());
        executeParamModel.setSystemParams(inputParamValues);
        List results = this.dataViewService.executeQuery(executeParamModel);
        context.getParams().put(contextParamName, CollectionUtils.isEmpty((Collection)results) ? new ArrayList() : results);
    }

    @Override
    public Class<RuntimeDataViewNode> mapping() {
        return RuntimeDataViewNode.class;
    }
}

