/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.mars.policy.process.rule.logic;

import com.bizunited.platform.core.entity.ScriptEntity;
import com.bizunited.platform.core.service.ScriptService;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.mars.entity.RuleSourceScriptEntity;
import com.bizunited.platform.mars.policy.process.cache.RuntimeNodeParams;
import com.bizunited.platform.mars.policy.process.cache.RuntimeProcessorLinked;
import com.bizunited.platform.mars.policy.process.cache.logic.RuntimeScriptNode;
import com.bizunited.platform.mars.policy.process.executor.ProcessorChain;
import com.bizunited.platform.mars.policy.process.rule.logic.AbstractLogicRuleable;
import com.bizunited.platform.mars.policy.process.rule.logic.LogicRuleable;
import com.bizunited.platform.mars.policy.process.runtime.contexts.RuleRuntimeContext;
import com.bizunited.platform.mars.policy.process.runtime.service.RuntimeDefinitionService;
import com.bizunited.platform.mars.policy.process.runtime.service.RuntimeNodeService;
import com.bizunited.platform.mars.service.RuleSourceScriptService;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="groovyScriptProcessRuleable")
public class GroovyScriptProcessRuleable<T extends RuntimeScriptNode>
extends AbstractLogicRuleable<RuntimeScriptNode>
implements LogicRuleable<RuntimeScriptNode> {
    @Autowired
    private ScriptService scriptService;
    @Autowired
    private RuntimeNodeService runtimeNodeService;
    @Autowired
    private RuntimeDefinitionService runtimeDefinitionService;
    @Autowired
    private RuleSourceScriptService ruleSourceScriptService;
    private static final Logger LOGGER = LoggerFactory.getLogger(GroovyScriptProcessRuleable.class);

    @Override
    public void doProcess(RuntimeScriptNode currentNode, RuleRuntimeContext context, RuntimeProcessorLinked runtimeProcessorLinked, ProcessorChain processChain) {
        super.process(currentNode, runtimeProcessorLinked);
        processChain.doProcessNode(context, runtimeProcessorLinked);
    }

    @Override
    protected void execute(RuntimeScriptNode currentNode, Map<String, Object> inputParamValues, RuleRuntimeContext context) {
        String code = currentNode.getCode();
        Validate.notBlank((CharSequence)code, (String)"\u5728\u8fdb\u884c\u8282\u70b9\u5b9a\u4e49\u6267\u884c\u65f6\uff0c\u8282\u70b9\u5b9a\u4e49\u7684code\u5fc5\u987b\u6709\u503c\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2!!", (Object[])new Object[0]);
        Validate.notNull((Object)currentNode, (String)"\u8fd0\u884c\u8282\u70b9[%s]\u65f6\uff0c\u672a\u53d1\u73b0\u5904\u7406\u6e90\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{code});
        String scriptId = currentNode.getScriptId();
        Validate.notBlank((CharSequence)scriptId, (String)"\u8fd0\u884c\u8282\u70b9[%s]\u65f6\uff0c\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u811a\u672cId\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{code});
        RuleSourceScriptEntity ruleSourceScript = this.ruleSourceScriptService.findById(scriptId);
        Validate.notNull((Object)ruleSourceScript, (String)"\u8fd0\u884c\u8282\u70b9[%s]\u65f6\uff0c\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u811a\u672cId\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{code});
        ScriptEntity scriptEntity = ruleSourceScript.getScript();
        String scriptContent = this.scriptService.findContentById(scriptEntity.getId());
        Validate.notBlank((CharSequence)scriptContent, (String)"\u8fd0\u884c\u8282\u70b9[%s]\u65f6\uff0c\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u811a\u672c\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{code});
        String language = scriptEntity.getLanguage();
        Validate.isTrue((boolean)StringUtils.equals((CharSequence)language, (CharSequence)"groovy"), (String)"\u8fd0\u884c\u8282\u70b9[%s]\u65f6\uff0c\u53d1\u73b0\u811a\u672c\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{code});
        inputParamValues.putAll(context.getParams());
        inputParamValues.put("runtimeNodeService", this.runtimeNodeService);
        inputParamValues.put("runtimeDefinitionService", this.runtimeDefinitionService);
        HashMap outputParamValues = null;
        try {
            outputParamValues = this.scriptService.invoke(new String[]{scriptEntity.getId()}, inputParamValues);
        }
        catch (InvokeProxyException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        if (outputParamValues == null) {
            outputParamValues = new HashMap();
        }
        Map<String, Object> contentMap = context.getParams();
        Set<RuntimeNodeParams> outputParams = currentNode.getOutputs();
        if (outputParams != null) {
            for (RuntimeNodeParams item : outputParams) {
                boolean nullable = item.getNullable();
                String templateParamName = item.getTemplateParamName();
                String contextParamName = item.getContextParamName();
                Object outputValue = outputParamValues.get(templateParamName);
                if (outputValue == null && nullable) {
                    String errorMsg = String.format("\u5206\u6790\u8fd0\u884c\u8282\u70b9[%s]\u8fd4\u56de\u503c\u65f6\uff0c\u53d1\u73b0\u6307\u5b9a\u7684\u51fa\u53c2[%s]\u8bbe\u5b9a\u4e3anot nullable\uff0c\u4f46\u662f\u6267\u884c\u7ed3\u679c\u5374\u6ca1\u6709\u8fd4\u56de\u503c\uff0c\u8bf7\u68c0\u67e5", code, templateParamName);
                    throw new IllegalArgumentException(errorMsg);
                }
                contentMap.put(contextParamName, outputValue);
            }
        }
    }

    @Override
    public Class<RuntimeScriptNode> mapping() {
        return RuntimeScriptNode.class;
    }
}

