package com.bizunited.platform.mars.policy.process.rule.logic;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.entity.DataViewEntity;
import com.bizunited.platform.core.service.dataview.DataViewService;
import com.bizunited.platform.core.service.dataview.model.ExecuteParamModel;
import com.bizunited.platform.mars.policy.process.cache.RuntimeNodeParams;
import com.bizunited.platform.mars.policy.process.cache.RuntimeProcessorLinked;
import com.bizunited.platform.mars.policy.process.cache.logic.RuntimeDataViewNode;
import com.bizunited.platform.mars.policy.process.executor.ProcessorChain;
import com.bizunited.platform.mars.policy.process.runtime.contexts.RuleRuntimeContext;

/**
 * 基于数据视图（集合）节点的逻辑运行器
 * @author yinwenjie
 */
@Component("dataviewProcessRuleable")
public class DataviewProcessRuleable<T extends RuntimeDataViewNode> extends AbstractLogicRuleable<RuntimeDataViewNode> implements LogicRuleable<RuntimeDataViewNode> {
  @Autowired
  private DataViewService dataViewService;
  
  @Override
  public void doProcess(RuntimeDataViewNode currentNode, RuleRuntimeContext context ,RuntimeProcessorLinked runtimeProcessorLinked, ProcessorChain processChain) {
    super.process(currentNode, runtimeProcessorLinked);
    processChain.doProcessNode(context, runtimeProcessorLinked);
  }

  @Override
  protected void execute(RuntimeDataViewNode currentNode, Map<String, Object> inputParamValues, RuleRuntimeContext context) {
    String viewCode = currentNode.getViewCode();
    Validate.notNull(viewCode , "在基于数据视图的条件判定处理器工作时，未发现指定的codeView信息，请检查配置");
    DataViewEntity currentDataView =  dataViewService.findDetailsByCode(viewCode);
    Validate.notNull(currentDataView, "未发现指定的数据视图信息[%s]，请检查!!", viewCode);
    // 开始进行数据视图的调用
    ExecuteParamModel dataViewParamModel = new ExecuteParamModel();
    dataViewParamModel.setSystemParams(inputParamValues);
    dataViewParamModel.setDataViewCode(currentDataView.getCode());
    if(currentDataView.getDataSource() != null) {
      dataViewParamModel.setDataSourceCode(currentDataView.getDataSource().getCode());
    }
    
    // 开始配定返回值，如果outputParams == null说明没有设定返回值
    Set<RuntimeNodeParams> outputParams = currentNode.getOutputs();
    Validate.isTrue(outputParams == null || (outputParams != null && outputParams.size() == 1) , "运行节点[%s]时，发现其设定的出参不符合要求(要么不设定返回值，要么只设置一个返回值参数)!!");
    if(outputParams == null) {
      return;
    }
    RuntimeNodeParams outputParam = outputParams.iterator().next();
    String contextParamName = outputParam.getContextParamName();
    
    // 构建数据视图的查询，并将查询结果存储到规则执行上下文中
    ExecuteParamModel executeParamModel = new ExecuteParamModel();
    executeParamModel.setDataViewCode(currentNode.getViewCode());
    executeParamModel.setSystemParams(inputParamValues);
    List<JSONObject> results = dataViewService.executeQuery(executeParamModel);
    context.getParams().put(contextParamName, CollectionUtils.isEmpty(results)?new ArrayList<>() : results);
  }

  @Override
  public Class<RuntimeDataViewNode> mapping() {
    return RuntimeDataViewNode.class;
  }
}
