package com.bizunited.platform.mars.policy.process.rule.waiter;

import org.springframework.stereotype.Component;

import com.bizunited.platform.mars.policy.process.cache.RuntimeNodeType;
import com.bizunited.platform.mars.policy.process.cache.RuntimeProcessorLinked;
import com.bizunited.platform.mars.policy.process.cache.waiter.RuntimeTimerNode;
import com.bizunited.platform.mars.policy.process.executor.ProcessorChain;
import com.bizunited.platform.mars.policy.process.rule.starter.AbstractProcessorLinkedCreator;
import com.bizunited.platform.mars.policy.process.rule.starter.StarterRuleable;
import com.bizunited.platform.mars.policy.process.runtime.contexts.RuleRuntimeContext;

/**
 * 阻塞计时器规则节点
 * @author yinwenjie
 */
@Component("_timeRuleable")
public class TimerRuleable<T extends RuntimeTimerNode> extends AbstractProcessorLinkedCreator<RuntimeTimerNode> implements StarterRuleable<RuntimeTimerNode> {
  public int getType() {
    return RuntimeNodeType.TIMER.getValue();
  }
  @Override
  public void doProcess(RuntimeTimerNode currentNode, RuleRuntimeContext context,RuntimeProcessorLinked runtimeProcessorLinked, ProcessorChain processChain) {
    /*
     * 阻塞计时器节点没有任何业务逻辑过程需要执行
     */
    processChain.doProcessNode(context, runtimeProcessorLinked);
  }
  
  @Override
  public Class<RuntimeTimerNode> mapping() {
    return RuntimeTimerNode.class;
  }
}
