/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.mars.policy.process.rule.waiter;

import com.bizunited.platform.mars.policy.process.cache.RuntimeNodeNexts;
import com.bizunited.platform.mars.policy.process.cache.RuntimeNodeType;
import com.bizunited.platform.mars.policy.process.cache.RuntimeProcessorLinked;
import com.bizunited.platform.mars.policy.process.cache.waiter.RuntimeParallelBranchNode;
import com.bizunited.platform.mars.policy.process.executor.ProcessorChain;
import com.bizunited.platform.mars.policy.process.rule.starter.StarterRuleable;
import com.bizunited.platform.mars.policy.process.runtime.contexts.RuleRuntimeContext;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Component;

@Component(value="_ParallelBranchRuleable")
public class ParallelBranchRuleable<T extends RuntimeParallelBranchNode>
implements StarterRuleable<RuntimeParallelBranchNode> {
    @Override
    public int getType() {
        return RuntimeNodeType.MERGE.getValue();
    }

    @Override
    public void doProcess(RuntimeParallelBranchNode currentNode, RuleRuntimeContext context, RuntimeProcessorLinked runtimeProcessorLinked, ProcessorChain processChain) {
        processChain.doProcessNode(context, runtimeProcessorLinked);
    }

    @Override
    public Set<RuntimeProcessorLinked> createProcessorLinkeds(RuntimeParallelBranchNode currentNode, RuleRuntimeContext context) {
        Set<RuntimeNodeNexts> nexts = currentNode.getNexts();
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(nexts), (String)"\u5f53\u524d\u8282\u70b9\u540e\u7eed\u8fd0\u884c\u65f6\u8fde\u7ebf\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        RuntimeNodeType type = currentNode.getType();
        Validate.isTrue((type == RuntimeNodeType.CONCURRENCY ? 1 : 0) != 0, (String)"\u5f53\u524d\u8282\u70b9\u4e0d\u662fA/B\u5e76\u53d1\u7c7b\u578b\u7684\u8fd0\u884c\u65f6\u8282\u70b9\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)currentNode.getParamName(), (String)"A/B\u5e76\u884c\u8282\u70b9\u53c2\u6570\u540d\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Set sortNexts = nexts.stream().filter(item -> item.getLineType() == 1).sorted((source, target) -> source.getSort() - target.getSort()).collect(Collectors.toSet());
        HashSet runtimeProcessorLinkeds = Sets.newHashSet();
        List<?> params = this.getParams(context, currentNode.getParamName());
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(params), (String)"A/B\u5e76\u884c\u8282\u70b9\u96c6\u5408\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        int groupSize = sortNexts.size();
        List<List<?>> subLists = this.splitList(params, groupSize);
        int current = 0;
        for (RuntimeNodeNexts next : sortNexts) {
            String bindParam = next.getBindParam();
            if (StringUtils.isBlank((CharSequence)bindParam)) {
                bindParam = currentNode.getParamName() + "_" + current;
            }
            context.getParams().put(bindParam, subLists.get(current));
            RuntimeProcessorLinked runtimeProcessorLinked = new RuntimeProcessorLinked(currentNode, next);
            runtimeProcessorLinkeds.add(runtimeProcessorLinked);
            ++current;
        }
        return runtimeProcessorLinkeds;
    }

    private List<List<?>> splitList(List<?> params, Integer groupSize) {
        int dataSize = params.size();
        Validate.isTrue((dataSize >= groupSize ? 1 : 0) != 0, (String)"\u8f93\u5165\u6570\u636e\u96c6\u5408\u5c0f\u4e8e\u9700\u8981\u5206\u7ec4\u6570\uff0c\u65e0\u6cd5\u968f\u673a\u5206\u7ec4\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        ArrayList result = Lists.newArrayListWithCapacity((int)groupSize);
        List<?> subList = null;
        int[] splitSize = this.getRandomSplitSize(groupSize, dataSize);
        int start = 0;
        for (int s : splitSize) {
            subList = params.subList(start, start + s);
            start += s;
            result.add(subList);
        }
        return result;
    }

    private int[] getRandomSplitSize(Integer groupSize, Integer dataSize) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int[] result = new int[groupSize.intValue()];
        int randomNum = 0;
        int tmp = 0;
        for (int i = 0; i < dataSize; ++i) {
            tmp = this.sum(result);
            if (i == groupSize - 1 || tmp == dataSize) {
                result[i] = dataSize - tmp;
                break;
            }
            randomNum = ((Random)random).nextInt((dataSize - tmp) / (groupSize - i)) + 1;
            if (tmp + randomNum > dataSize) continue;
            result[i] = randomNum;
        }
        return result;
    }

    private int sum(int[] datas) {
        int sum = 0;
        for (int d : datas) {
            sum += d;
        }
        return sum;
    }

    private List<?> getParams(RuleRuntimeContext context, String paramName) {
        Object params = context.getParams().get(paramName);
        Validate.notNull((Object)params, (String)"A/B\u5e76\u884c\u8282\u70b9\u4e0a\u4e0b\u6587\u53c2\u6570\u4e3a\u7a7a,\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((params.getClass().isArray() || Collection.class.isAssignableFrom(params.getClass()) ? 1 : 0) != 0, (String)"\u5236\u5b9a\u53c2\u6570\u4e0d\u662f\u96c6\u5408\u6216\u8005\u6570\u7ec4\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        LinkedList paramList = null;
        if (params.getClass().isArray()) {
            Object[] arr = (Object[])params;
            paramList = Arrays.asList(arr);
        } else if (Collection.class.isAssignableFrom(params.getClass())) {
            Collection collection = (Collection)params;
            paramList = Lists.newLinkedList((Iterable)collection);
        }
        return paramList;
    }

    @Override
    public Class<RuntimeParallelBranchNode> mapping() {
        return RuntimeParallelBranchNode.class;
    }
}

