package com.bizunited.platform.mars.policy.process.cache.ext;

import com.bizunited.platform.mars.entity.RuleNodeEntity;
import com.bizunited.platform.mars.policy.process.cache.Mappable;
import com.bizunited.platform.mars.policy.process.cache.waiter.RuntimeDelayNode;
import org.apache.commons.lang3.Validate;

/**
 * A/B并行以及条件判定业务条件扩展节点，定义流程走向（一条或者多条链路）：</br>
 * 为了满足业务开发人员对于条件判定与A/B并发的自定义复杂逻辑的需求。</br>
 * 1、条件扩展节点支持动态模板与自定义页面的形式</br>
 * 2、条件扩展节点不参数数据，只要实现对链路走向的判定工作</br>
 * 3、条件扩展节点业务人员可以通过连接的下一个节点编码来确定流程走向
 *
 * @author Keller
 */
public class RuntimeConditionExtNode extends RuntimeDelayNode implements Mappable<RuleNodeEntity, RuntimeDelayNode> {
  /**
   * 业务扩展节点的类型，可由技术团队自行设定
   */
  private Integer extType;
  /**
   * 弹窗的高度，可以是像素或者百分比
   */
  private Integer showHight;
  /**
   * 弹窗的宽度，可以是像素或者百分比
   */
  private Integer showWidth;
  /**
   * 如果需要进行页面引擎弹窗，则这里可填写弹窗的标题信息
   */
  private String showTitle;
  /**
   * 这个业务扩展组件是否使用（动态）表单引擎作为操作界面
   */
  private Boolean formEngine;
  /**
   * 当前表单引擎使用的表单实例号
   */
  private String formInstanceId;
  /**
   * 这个业务扩展组件是否使用用户自定义的业务扩展页面
   */
  private Boolean userPage;
  /**
   * 当业务扩展组件在规则定义页面进行设定数据保存时，向表单页面提供的业务数据唯一标识信息</br>
   * 例如，如果是订单页面，则可能返回订单数据的id
   */
  private String taskCode;
  /**
   * 当业务扩展组件需要在规则定义页面需要展开并回显数据时</br>
   * 就会使用该参数名进行url请求，例如:/xxxx/show?taskName=taskCode;
   */
  private String taskName;

  public Integer getExtType() {
    return extType;
  }
  public void setExtType(Integer extType) {
    this.extType = extType;
  }
  public Integer getShowHight() {
    return showHight;
  }
  public void setShowHight(Integer showHight) {
    this.showHight = showHight;
  }
  public Integer getShowWidth() {
    return showWidth;
  }
  public void setShowWidth(Integer showWidth) {
    this.showWidth = showWidth;
  }
  public String getShowTitle() {
    return showTitle;
  }
  public void setShowTitle(String showTitle) {
    this.showTitle = showTitle;
  }
  public Boolean getFormEngine() {
    return formEngine;
  }
  public void setFormEngine(Boolean formEngine) {
    this.formEngine = formEngine;
  }
  public String getFormInstanceId() {
    return formInstanceId;
  }
  public void setFormInstanceId(String formInstanceId) {
    this.formInstanceId = formInstanceId;
  }
  public Boolean getUserPage() {
    return userPage;
  }
  public void setUserPage(Boolean userPage) {
    this.userPage = userPage;
  }
  public String getTaskCode() {
    return taskCode;
  }
  public void setTaskCode(String taskCode) {
    this.taskCode = taskCode;
  }
  public String getTaskName() {
    return taskName;
  }
  public void setTaskName(String taskName) {
    this.taskName = taskName;
  }

  @Override
  public RuntimeConditionExtNode mappingTransform(RuleNodeEntity ruleNode) {
    RuntimeConditionExtNode currentNode = super.doMappingTransform(RuntimeConditionExtNode.class, ruleNode);
    Integer extType = currentNode.getExtType();
    Validate.notNull(extType , "错误的业务扩展节点类型[extType]，请检查!!");
    return currentNode;
  }
}
