package com.bizunited.platform.mars.policy.process.rule.ext;

import com.bizunited.platform.mars.policy.process.cache.RuntimeNodeType;
import com.bizunited.platform.mars.policy.process.cache.RuntimeProcessorLinked;
import com.bizunited.platform.mars.policy.process.cache.ext.RuntimeConditionExtNode;
import com.bizunited.platform.mars.policy.process.executor.ProcessorChain;
import com.bizunited.platform.mars.policy.process.runtime.contexts.RuleRuntimeContext;
import org.apache.commons.compress.utils.Sets;
import org.apache.commons.lang3.Validate;

import java.util.Set;

/**
 * 用户扩展条件节点处理器
 *
 * @author Keller
 */
public abstract class AbstractConditionExtRuleable implements ConditionExtRuleable<RuntimeConditionExtNode> {
  /**
   * 所有判定条件业务扩展组件的实现都需要实现该方法，用于向执行器说明
   * 作为判定条件业务扩展节点的处理器，本身支持的业务节点扩展类型值是多少
   * @return
   */
  public abstract int mappingExtType();

  /**
   * 判定条件业务扩展创建链路方法
   * 需要业务人员实现对链路的判定并返回执行的链路信息
   * 条件判定节点最终只能确定一条执行链路(如需多条链路并发执行，请使用{@link com.bizunited.platform.mars.policy.process.rule.ext.AbstractParallelBranchExtRuleable}
   *
   * @param currentNode
   * @param context
   * @return
   */
  public abstract RuntimeProcessorLinked createProcessorLinked(RuntimeConditionExtNode currentNode, RuleRuntimeContext context);

  @Override
  public final Set<RuntimeProcessorLinked> createProcessorLinkeds(RuntimeConditionExtNode currentNode, RuleRuntimeContext context) {
    RuntimeProcessorLinked runtimeProcessorLinked = this.createProcessorLinked(currentNode,context);
    Validate.notNull(runtimeProcessorLinked,"创建链路为空，请检查返回链路信息");
    return Sets.newHashSet(runtimeProcessorLinked);
  }

  /**
   * 业务扩展节点就不再是通过运行时节点runtimeNode的具体类来匹配处理器了</br>
   * 而是通过type和extType来匹配处理器了，所以该方法一直返回null，且不再允许被覆盖
   */
  @Override
  public final Class<RuntimeConditionExtNode> mapping() {
    return null;
  }

  /**
   * 业务扩展条件节点为开始节点，无上一步节点，默认进行下一步的调用。
   * @param currentNode 当前正在处理的运行时节点
   * @param context 规则引擎运行时上下文
   * @param runtimeProcessorLinked 当前节点运行时所属的规则链路定义
   * @param processChain 规则执行的控制器
   */
  @Override
  public final void doProcess(RuntimeConditionExtNode currentNode, RuleRuntimeContext context, RuntimeProcessorLinked runtimeProcessorLinked, ProcessorChain processChain) {
    processChain.doProcessNode(context, runtimeProcessorLinked);
  }

  @Override
  public final int getType() {
    return RuntimeNodeType.CUSTOM_CONDITION.getValue();
  }
}
