/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.mars.policy.process.runtime.service;

import com.bizunited.platform.mars.policy.process.runtime.RuleRunTimeStatus;
import com.bizunited.platform.mars.policy.process.runtime.contexts.RuleRuntimeContext;
import com.bizunited.platform.mars.policy.process.runtime.service.ProcessCallback;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.LockSupport;
import org.apache.commons.lang3.Validate;

public class DefinitionProcessFuture
implements Future<Object> {
    private RuleRuntimeContext ruleRuntimeContext;
    private ProcessCallback processCallback;

    DefinitionProcessFuture(RuleRuntimeContext ruleRuntimeContext) {
        this.ruleRuntimeContext = ruleRuntimeContext;
    }

    DefinitionProcessFuture(RuleRuntimeContext ruleRuntimeContext, ProcessCallback processCallback) {
        this.ruleRuntimeContext = ruleRuntimeContext;
        this.processCallback = processCallback;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.ruleRuntimeContext.getStatus() != RuleRunTimeStatus.NORMAL;
    }

    @Override
    public Object get() throws InterruptedException, ExecutionException {
        LockSupport.park(this.ruleRuntimeContext);
        if (this.ruleRuntimeContext.getStatus() == RuleRunTimeStatus.EXCEPTION) {
            throw new IllegalArgumentException(this.ruleRuntimeContext.getCurrentThrowable().getMessage());
        }
        if (this.processCallback != null) {
            this.processCallback.doInvocation(this.ruleRuntimeContext);
        }
        return this.ruleRuntimeContext.get_return();
    }

    @Override
    public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Validate.isTrue((timeout > 0L ? 1 : 0) != 0, (String)"DefinitionProcessFuture.get\uff0c\u53c2\u8003\u7684\u963b\u585e\u65f6\u95f4\u503c\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        TimeUnit currentUnit = unit;
        if (currentUnit == null) {
            currentUnit = TimeUnit.MILLISECONDS;
        }
        LockSupport.parkNanos(this.ruleRuntimeContext, TimeUnit.NANOSECONDS.convert(timeout, currentUnit));
        if (this.ruleRuntimeContext.getStatus() == RuleRunTimeStatus.EXCEPTION) {
            throw new IllegalArgumentException(this.ruleRuntimeContext.getCurrentThrowable().getMessage());
        }
        return this.ruleRuntimeContext.get_return();
    }
}

