package com.bizunited.platform.mars.policy.process.configuration;

import java.util.concurrent.DelayQueue;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import com.bizunited.platform.mars.policy.process.cache.waiter.RuntimeDelayNode;

/**
 * 这是一个延迟计时器的封装，java原生的延时计时队列已经足够满足要求，所以这里只需要做一个队列使用的封装，即可
 * @author yinwenjie
 */
@Configuration
public class DelayTimerQueueConfig {
  @Bean("_delayTimerQueue")
  public DelayQueue<RuntimeDelayNode> getDelayTimerQueue() {
    return new DelayQueue<>();
  }
}