package com.bizunited.platform.mars.policy.process.rule.waiter;

import java.util.Set;
import java.util.stream.Collectors;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import com.bizunited.platform.mars.policy.process.cache.RuntimeDefinition;
import com.bizunited.platform.mars.policy.process.cache.RuntimeNodeNexts;
import com.bizunited.platform.mars.policy.process.cache.RuntimeNodeType;
import com.bizunited.platform.mars.policy.process.cache.RuntimeProcessorLinked;
import com.bizunited.platform.mars.policy.process.cache.waiter.RuntimeConcurrentAggregationNode;
import com.bizunited.platform.mars.policy.process.executor.ProcessorChain;
import com.bizunited.platform.mars.policy.process.rule.starter.AbstractProcessorLinkedCreator;
import com.bizunited.platform.mars.policy.process.rule.starter.StarterRuleable;
import com.bizunited.platform.mars.policy.process.runtime.contexts.RuleRuntimeContext;
import com.bizunited.platform.mars.policy.process.runtime.service.RuntimeNodeNextsService;

/**
 * 并行汇聚节点，只有当该节点所有前置分支链路全部成功执行，该汇聚节点才会继续向后执行
 * @author yinwenjie
 */
@Component("_ConcurrentAggregationRuleable")
public class ConcurrentAggregationRuleable<T extends RuntimeConcurrentAggregationNode> extends AbstractProcessorLinkedCreator<RuntimeConcurrentAggregationNode> implements StarterRuleable<RuntimeConcurrentAggregationNode> {
  @Autowired
  private RuntimeNodeNextsService runtimeNodeNextsService;
  
  public int getType() {
    return RuntimeNodeType.CONCURRENCY.getValue();
  }
  
  @Override
  public void doProcess(RuntimeConcurrentAggregationNode currentNode, RuleRuntimeContext context,RuntimeProcessorLinked runtimeProcessorLinked, ProcessorChain processChain) {
    /*
     * 该节点没有任何业务动作
     * */
    processChain.doProcessNode(context, runtimeProcessorLinked);
  }
  
  @Override
  public Set<RuntimeProcessorLinked> createProcessorLinkeds(RuntimeConcurrentAggregationNode currentNode, RuleRuntimeContext context) {
    /*
     * 在接收到继续的通知，正式开始继续执行前，ConcurrentAggregationRuleable节点会做以下判定：
     * 1、规则实例中，是否所有以当前节点为结束节点的规则链路都已经执行完毕
     * 2、以上判定成立的条件下，是否所有所有链路都执行成功了
     * 
     * 只有以上两个条件都成立的情况下，才会创建后续规则链路，并继续执行
     * */
    
    // 1、=====
    Set<RuntimeProcessorLinked> runtimeProcessorLinkeds = context.getRuntimeProcessorLinkeds();
    if(CollectionUtils.isEmpty(runtimeProcessorLinkeds)) {
      return null;
    }
    RuntimeDefinition runtimeDefinition = context.getRuntimeDefinition();
    // 这里查询得到的是应该运行的所有连线
    Set<RuntimeNodeNexts> runtimeNodeNexts = runtimeNodeNextsService.findByEndCode(runtimeDefinition, currentNode.getCode());
    Validate.isTrue(runtimeNodeNexts.size() > 0 , "未发现指定节点【%s】在规则定义中的任何连线，请检查!!" , currentNode.getCode());
    
    
    // 2、=====
    // 这是查询得到的已经完成运行的链路
    Set<RuntimeProcessorLinked> processorLinkedRunneds = runtimeProcessorLinkeds.stream().filter(item -> item.getTerminator() != null && StringUtils.equals(item.getTerminator().getCode(), currentNode.getCode())).collect(Collectors.toSet());
    // 如果条件成立，说明至少还有连接到currentNode上的一条链路没有运行，所以汇聚链路还不能进行运行
    if(processorLinkedRunneds.size() != runtimeNodeNexts.size()) {
      return null;
    }
    
    // 运行到这里，说明该汇聚链路可以运行了，则构建新的（且唯一的）RuntimeProcessorLinked，并进行运行
    return super.createProcessorLinkeds(currentNode, context);
  }

  @Override
  public Class<RuntimeConcurrentAggregationNode> mapping() {
    return RuntimeConcurrentAggregationNode.class;
  }
}
