package com.bizunited.platform.mars.policy.process.cache.ext;

import com.bizunited.platform.mars.entity.RuleConcurrentAggregationEntity;
import com.bizunited.platform.mars.entity.RuleNodeEntity;
import com.bizunited.platform.mars.policy.process.cache.Mappable;
import com.bizunited.platform.mars.policy.process.cache.waiter.RuntimeDelayNode;
import org.apache.commons.lang3.Validate;

/**
 * @author Keller
 */
public class RuntimeParallelBranchExtNode extends RuntimeDelayNode implements Mappable<RuleNodeEntity, RuntimeDelayNode> {
  /**
   * 业务扩展节点的类型，可由技术团队自行设定
   */
  private Integer extType;
  /**
   * 弹窗的高度，可以是像素或者百分比
   */
  private Integer showHight;
  /**
   * 弹窗的宽度，可以是像素或者百分比
   */
  private Integer showWidth;
  /**
   * 如果需要进行页面引擎弹窗，则这里可填写弹窗的标题信息
   */
  private String showTitle;
  /**
   * 这个业务扩展组件是否使用（动态）表单引擎作为操作界面
   */
  private Boolean formEngine;
  /**
   * 当前表单引擎使用的表单实例号
   */
  private String formInstanceId;
  /**
   * 这个业务扩展组件是否使用用户自定义的业务扩展页面
   */
  private Boolean userPage;
  /**
   * 当业务扩展组件在规则定义页面进行设定数据保存时，向表单页面提供的业务数据唯一标识信息</br>
   * 例如，如果是订单页面，则可能返回订单数据的id
   */
  private String taskCode;
  /**
   * 当业务扩展组件需要在规则定义页面需要展开并回显数据时</br>
   * 就会使用该参数名进行url请求，例如:/xxxx/show?taskName=taskCode;
   */
  private String taskName;

  /**
   * A/B并行上下文参数名
   */
  private String paramName;

  public Integer getExtType() {
    return extType;
  }
  public void setExtType(Integer extType) {
    this.extType = extType;
  }
  public Integer getShowHight() {
    return showHight;
  }
  public void setShowHight(Integer showHight) {
    this.showHight = showHight;
  }
  public Integer getShowWidth() {
    return showWidth;
  }
  public void setShowWidth(Integer showWidth) {
    this.showWidth = showWidth;
  }
  public String getShowTitle() {
    return showTitle;
  }
  public void setShowTitle(String showTitle) {
    this.showTitle = showTitle;
  }
  public Boolean getFormEngine() {
    return formEngine;
  }
  public void setFormEngine(Boolean formEngine) {
    this.formEngine = formEngine;
  }
  public String getFormInstanceId() {
    return formInstanceId;
  }
  public void setFormInstanceId(String formInstanceId) {
    this.formInstanceId = formInstanceId;
  }
  public Boolean getUserPage() {
    return userPage;
  }
  public void setUserPage(Boolean userPage) {
    this.userPage = userPage;
  }
  public String getTaskCode() {
    return taskCode;
  }
  public void setTaskCode(String taskCode) {
    this.taskCode = taskCode;
  }
  public String getTaskName() {
    return taskName;
  }
  public void setTaskName(String taskName) {
    this.taskName = taskName;
  }
  public String getParamName() {
    return paramName;
  }
  public void setParamName(String paramName) {
    this.paramName = paramName;
  }

  @Override
  public RuntimeParallelBranchExtNode mappingTransform(RuleNodeEntity ruleNode) {
    RuntimeParallelBranchExtNode currentNode = super.doMappingTransform(RuntimeParallelBranchExtNode.class, ruleNode);
    Integer extType = currentNode.getExtType();
    Validate.notNull(extType , "错误的业务扩展节点类型[extType]，请检查!!");
    RuleConcurrentAggregationEntity ruleConcurrentAggregation = ruleNode.getRuleAggregationExt();
    Validate.notNull(ruleConcurrentAggregation,"扩展A/B并发节点扩展参数错误,请检查！");
    currentNode.setParamName(ruleConcurrentAggregation.getParamName());
    return currentNode;
  }
}
