package com.bizunited.platform.mars.policy.process.rule.starter;

import java.util.Set;

import org.apache.commons.lang3.Validate;
import org.springframework.util.CollectionUtils;

import com.bizunited.platform.mars.policy.process.cache.RuntimeNodeNexts;
import com.bizunited.platform.mars.policy.process.cache.RuntimeProcessorLinked;
import com.bizunited.platform.mars.policy.process.cache.waiter.RuntimeDelayNode;
import com.bizunited.platform.mars.policy.process.runtime.contexts.RuleRuntimeContext;
import com.google.common.collect.Sets;

/**
 * 为了减少代码重复率，很多情况下，规则链路的开始节点只允许有一条后续的连线</br>
 * 所以需要该抽象类做一个创建规则链路，普遍性的、通常性的实现
 * @author yinwenjie
 *
 */
public abstract class AbstractProcessorLinkedCreator<T extends RuntimeDelayNode> implements StarterRuleable<T> {

  /**
   * 这种默认的实现下，只适合当前开始性质的节点只有一条后续连接线的情况
   */
  @Override
  public Set<RuntimeProcessorLinked> createProcessorLinkeds(T currentNode, RuleRuntimeContext context) {
    /*
     * 作为普通的，代表整个规则定义的开始节点，可以无条件启动运行
     * 按照当前规则定义，找到第一个处理点和处理连线即可
     * */
    
    Set<RuntimeNodeNexts> runtimeNodeNexts = currentNode.getNexts();
    Validate.isTrue(!CollectionUtils.isEmpty(runtimeNodeNexts) , "未发现当前节点运行时[%s]存在任何后续连线，请检查!!" , currentNode.getCode());
    Validate.isTrue(runtimeNodeNexts.size() == 1 , "当前开始节点的运行时定义，只能由一条连线，请检查!!");
    RuntimeNodeNexts currentRuntimeNodeNext = runtimeNodeNexts.iterator().next();
    
    // 为当前上下文设定规则链路，以便进行执行
    RuntimeProcessorLinked runtimeProcessorLinked = new RuntimeProcessorLinked(currentNode, currentRuntimeNodeNext);
    return Sets.newHashSet(runtimeProcessorLinked);
  }
}
