package com.bizunited.platform.mars.policy.process.rule.starter;

import java.util.Map;
import java.util.Set;

import org.springframework.stereotype.Component;

import com.bizunited.platform.mars.policy.process.cache.RuntimeProcessorLinked;
import com.bizunited.platform.mars.policy.process.cache.RuntimeNodeParams;
import com.bizunited.platform.mars.policy.process.cache.waiter.RuntimeStartNode;
import com.bizunited.platform.mars.policy.process.executor.ProcessorChain;
import com.bizunited.platform.mars.policy.process.runtime.contexts.RuleRuntimeContext;

/**
 * 开始规则的简单实现，其中创建规则链路的时候，只有一条连接线
 * @author yinwenjie
 */
@Component("simpleStarterRuleable")
public class SimpleStarterRuleable<T extends RuntimeStartNode> extends AbstractProcessorLinkedCreator<RuntimeStartNode> implements StarterRuleable<RuntimeStartNode> {
  @Override
  public void doProcess(RuntimeStartNode currentNode ,RuleRuntimeContext context ,RuntimeProcessorLinked runtimeProcessorLinked , ProcessorChain processChain) {
    /*
     * 开始位置，会按照当前开始节点的定义，检查入参情况是否满足
     * */
    Set<RuntimeNodeParams> runtimeNodeParams = currentNode.getInputs();
    Map<String, Object> contextParamMapping = context.getParams();
    
    if(runtimeNodeParams != null) {
      for (RuntimeNodeParams nodeParam : runtimeNodeParams) {
        boolean nullable = nodeParam.getNullable();
        String contextParamName = nodeParam.getContextParamName();
        if(nullable && contextParamMapping.get(contextParamName) == null) {
          throw new IllegalArgumentException(String.format("本规则实例要求[%s]作为入参，但是在运行开始时的检测中，并为发现该参数传入，请检查调用时的传参!!", contextParamName));
        }
      }
    }
    processChain.doProcessNode(context, runtimeProcessorLinked);
  }

  @Override
  public Class<RuntimeStartNode> mapping() {
    return RuntimeStartNode.class;
  }
}