package com.bizunited.platform.mars.policy.process.rule.end;

import org.springframework.stereotype.Component;

import com.bizunited.platform.mars.policy.process.cache.RuntimeProcessorLinked;
import com.bizunited.platform.mars.policy.process.cache.end.RuntimeEndNode;
import com.bizunited.platform.mars.policy.process.executor.ProcessorChain;
import com.bizunited.platform.mars.policy.process.runtime.contexts.RuleRuntimeContext;

/**
 * 一个默认的结束规则处理器，里面实际上什么都没有
 * @author yinwenjie
 */
@Component("SimpleEndRuleable")
public class SimpleEndRuleable<T extends RuntimeEndNode> implements EndRuleable<RuntimeEndNode> {
  
  @Override
  public void doProcess(RuntimeEndNode currentNode ,RuleRuntimeContext context ,RuntimeProcessorLinked runtimeProcessorLinked  , ProcessorChain processChain) {
    // 如果存在回调，则这里进行回调
    // 注意，这里已经给需求方明确表达，可能出现线程安全性问题
    if(context.getEndRuleableCallback() != null) {
      context.getEndRuleableCallback().doInvocation(currentNode, context);
    }
    processChain.doProcessNode(context, runtimeProcessorLinked);
  }

  @Override
  public String description() {
    return "默认的结束节点处理器";
  }
  
  @Override
  public Class<RuntimeEndNode> mapping() {
    return RuntimeEndNode.class;
  }
}