package com.bizunited.platform.mars.policy.process.rule.ext;

import com.bizunited.platform.mars.policy.process.cache.RuntimeNodeType;
import com.bizunited.platform.mars.policy.process.cache.ext.RuntimeExtNode;
import com.bizunited.platform.mars.policy.process.rule.Ruleable;

/**
 * 所有业务扩展节点的处理器，都必须继承该抽象类
 * @author yinwenjie
 */
public abstract class AbstractExtRuleable implements Ruleable<RuntimeExtNode> {

  @Override
  public final int getType() {
    return RuntimeNodeType.CUSTOM.getValue();
  }

  /**
   * 所有AbstractExtRuleable处理器的子类，都需要实现该方法，用于向执行器说明
   * 作为业务扩展节点的处理器，本身支持的业务节点扩展类型值是多少
   * @return
   */
  public abstract int mappingExtType();

  /**
   * 业务扩展节点就不再是通过运行时节点runtimeNode的具体类来匹配处理器了</br>
   * 而是通过type和extType来匹配处理器了，所以该方法一直返回null，且不再允许被覆盖
   */
  @Override
  public final Class<RuntimeExtNode> mapping() {
    return null;
  }
}
