package com.bizunited.platform.mars.policy.process.cache.logic;

import java.util.Set;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.util.CollectionUtils;

import com.bizunited.platform.mars.entity.RuleNodeEntity;
import com.bizunited.platform.mars.entity.RuleNodeParamsEntity;
import com.bizunited.platform.mars.policy.process.cache.Mappable;

/**
 * 节点运行时处理源全动态goovy脚本</br>
 * 执行groovy所需的入参和出参信息，在RuntimeNode中通过inputs、outputs进行确认
 * @author yinwenjie
 */
public class RuntimeDynamicScriptNode extends RuntimeLogicAble implements Mappable<RuleNodeEntity, RuntimeDynamicScriptNode> {
  /**
   * 脚本内容,脚本内容是在脚本定义时才填写，而不是模板定义时填写
   */
  private String scriptContent;
  
  private static final String SCRITPT_PARAM_NAME = "_script";
  
  public String getScriptContent() {
    return scriptContent;
  }
  public void setScriptContent(String scriptContent) {
    this.scriptContent = scriptContent;
  }
  @Override
  public RuntimeDynamicScriptNode mappingTransform(RuleNodeEntity ruleNode) {
    /*
     * 全动态脚本的脚本内容记录的方式很特殊，
     * 它是通过一个固定的入参"_script"中记录的字符串信息给定的
     * */
    Set<RuleNodeParamsEntity> inputs = ruleNode.getInputs();
    Validate.isTrue(!CollectionUtils.isEmpty(inputs) , "动态脚本中未发现有效的入参信息，请检查!!");
    RuleNodeParamsEntity ruleNodeParam = inputs.stream().filter(item -> StringUtils.equals(item.getTemplateParamName() , SCRITPT_PARAM_NAME)).findFirst().orElse(null);
    Validate.notNull(ruleNodeParam , "动态脚本中未发现有效的入参信息[%s]，请检查!!" , SCRITPT_PARAM_NAME);
    
    RuntimeDynamicScriptNode runtimeDynamicScriptNode = super.doMappingTransform(RuntimeDynamicScriptNode.class, ruleNode);
    runtimeDynamicScriptNode.setScriptContent(ruleNodeParam.getFixedValue());
    return runtimeDynamicScriptNode;
  }
}