package com.bizunited.platform.mars.policy.process.cache.logic;

import org.apache.commons.lang3.Validate;

import com.bizunited.platform.mars.entity.RuleNodeEntity;
import com.bizunited.platform.mars.entity.RuleSourceServicableEntity;
import com.bizunited.platform.mars.policy.process.cache.Mappable;

/**
 * 节点运行时处理源-服务源
 * @author yinwenjie
 */
public class RuntimeServicableNode extends RuntimeLogicAble implements Mappable<RuleNodeEntity, RuntimeServicableNode> {
  /**
   * 完整的服务源方法名
   */
  private String servicableMethod;

  public String getServicableMethod() {
    return servicableMethod;
  }

  public void setServicableMethod(String servicableMethod) {
    this.servicableMethod = servicableMethod;
  }

  @Override
  public RuntimeServicableNode mappingTransform(RuleNodeEntity ruleNode) {
    RuntimeServicableNode currentNode = super.doMappingTransform(RuntimeServicableNode.class, ruleNode);
    RuleSourceServicableEntity ruleSourceServicable = ruleNode.getTemplateNode().getSourceServicable();
    Validate.notNull(ruleSourceServicable , "未发现指定的持久层节点模板中，对应的数据视图设定信息，请检查!!");
    currentNode.setServicableMethod(ruleSourceServicable.getServicableMethod());
    return currentNode;
  }
}