/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.mars.policy.process.rule.logic;

import com.bizunited.platform.mars.policy.process.cache.RuntimeNode;
import com.bizunited.platform.mars.policy.process.cache.RuntimeNodeParams;
import com.bizunited.platform.mars.policy.process.cache.RuntimeProcessorLinked;
import com.bizunited.platform.mars.policy.process.cache.logic.RuntimeLogicAble;
import com.bizunited.platform.mars.policy.process.runtime.contexts.RuleRuntimeContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.util.CollectionUtils;

public abstract class AbstractLogicRuleable<T extends RuntimeLogicAble> {
    public void process(T currentNode, RuntimeProcessorLinked runtimeProcessorLinked) {
        String instanceId = ((RuntimeNode)currentNode).getInstanceId();
        RuleRuntimeContext context = RuleRuntimeContext.getRuleRuntimeContext(instanceId);
        Validate.notNull((Object)context, (String)"\u5f53\u524d\u8fd0\u884c\u7684\u8282\u70b9\u5b9a\u4e49\u672a\u53d1\u73b0\u8fd0\u884c\u4e0a\u4e0b\u6587\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String code = ((RuntimeNode)currentNode).getCode();
        Validate.notBlank((CharSequence)code, (String)"\u5f53\u524d\u8fd0\u884c\u7684\u8282\u70b9\u5b9a\u4e49\u672a\u53d1\u73b0\u4e1a\u52a1\u7f16\u53f7\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Map<String, Object> contentMap = context.getParams();
        Set<RuntimeNodeParams> inputParams = ((RuntimeNode)currentNode).getInputs();
        HashMap<String, Object> inputParamValues = new HashMap<String, Object>();
        if (!CollectionUtils.isEmpty(inputParams)) {
            inputParams.forEach(item -> {
                String contextParamName = item.getContextParamName();
                String fixValue = item.getFixedValue();
                String paramType = item.getParamType();
                Object paramValue = null;
                if (!StringUtils.isBlank((CharSequence)fixValue)) {
                    try {
                        paramValue = this.parseValue(fixValue, paramType);
                    }
                    catch (RuntimeException e) {
                        throw new IllegalArgumentException(String.format("\u56fa\u5b9a\u503c\u8f6c\u6362\u51fa\u73b0\u95ee\u9898[%s]\uff0c\u8bf7\u68c0\u67e5\u89c4\u5219\u5b9a\u4e49\u4e2d\u8282\u70b9[%s]\u7684\u56fa\u5b9a\u5165\u53c2\u8bbe\u7f6e\u3002", e.getMessage(), code));
                    }
                } else {
                    paramValue = contentMap.get(contextParamName);
                }
                if (paramValue == null && item.getNullable().booleanValue()) {
                    throw new IllegalArgumentException(String.format("\u8fd0\u884c\u8282\u70b9[%s]\u65f6\uff0c\u672a\u53d1\u73b0\u5fc5\u987b\u4f20\u5165\u7684\u5165\u53c2[%s]\uff0c\u8bf7\u68c0\u67e5!!", code, contextParamName));
                }
                String templateParamName = item.getTemplateParamName();
                inputParamValues.put(templateParamName, paramValue);
            });
        }
        this.execute(currentNode, inputParamValues, context);
    }

    protected abstract void execute(T var1, Map<String, Object> var2, RuleRuntimeContext var3);

    private Object parseValue(String fixValue, String type) {
        if (StringUtils.equals((CharSequence)type, (CharSequence)"long")) {
            return Long.valueOf(fixValue);
        }
        if (StringUtils.equals((CharSequence)type, (CharSequence)"int")) {
            return Integer.valueOf(fixValue);
        }
        if (StringUtils.equals((CharSequence)type, (CharSequence)"float")) {
            return Float.valueOf(fixValue);
        }
        if (StringUtils.equals((CharSequence)type, (CharSequence)"boolean")) {
            return Boolean.valueOf(fixValue);
        }
        if (StringUtils.equals((CharSequence)type, (CharSequence)"double")) {
            return Double.valueOf(fixValue);
        }
        if (StringUtils.equals((CharSequence)type, (CharSequence)"short")) {
            return Short.valueOf(fixValue);
        }
        if (StringUtils.equals((CharSequence)type, (CharSequence)"byte")) {
            return Byte.valueOf(fixValue);
        }
        return fixValue;
    }
}

