package com.bizunited.platform.mars.policy.process.cache.waiter;

import com.bizunited.platform.mars.entity.RuleNodeEntity;
import com.bizunited.platform.mars.policy.process.cache.Mappable;

/**
 * 规则定义中的开始节点的运行时定义
 * @author yinwenjie
 */
public class RuntimeStartNode extends RuntimeDelayNode implements Mappable<RuleNodeEntity, RuntimeStartNode> {
  
  /**
   * 开始节点需要重试执行
   */
  @Override
  public boolean reloadStartNode() {
    return true;
  }

  @Override
  public RuntimeStartNode mappingTransform(RuleNodeEntity ruleNode) {
    return super.doMappingTransform(RuntimeStartNode.class, ruleNode);
  }
}