/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.mars.policy.process.rule.logic;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.entity.DataViewEntity;
import com.bizunited.platform.core.service.dataview.DataViewService;
import com.bizunited.platform.core.service.dataview.model.ExecuteParamModel;
import com.bizunited.platform.mars.policy.process.cache.RuntimeNodeParams;
import com.bizunited.platform.mars.policy.process.cache.RuntimeProcessorLinked;
import com.bizunited.platform.mars.policy.process.cache.logic.RuntimeAggregateDataViewNode;
import com.bizunited.platform.mars.policy.process.executor.ProcessorChain;
import com.bizunited.platform.mars.policy.process.rule.logic.AbstractLogicRuleable;
import com.bizunited.platform.mars.policy.process.rule.logic.LogicRuleable;
import com.bizunited.platform.mars.policy.process.runtime.contexts.RuleRuntimeContext;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="dataviewAggregateProcessRuleable")
public class DataviewAggregateProcessRuleable<T extends RuntimeAggregateDataViewNode>
extends AbstractLogicRuleable<RuntimeAggregateDataViewNode>
implements LogicRuleable<RuntimeAggregateDataViewNode> {
    @Autowired
    private DataViewService dataViewService;

    @Override
    public void doProcess(RuntimeAggregateDataViewNode currentNode, RuleRuntimeContext context, RuntimeProcessorLinked runtimeProcessorLinked, ProcessorChain processChain) {
        super.process(currentNode, runtimeProcessorLinked);
        processChain.doProcessNode(context, runtimeProcessorLinked);
    }

    @Override
    protected void execute(RuntimeAggregateDataViewNode currentNode, Map<String, Object> inputParamValues, RuleRuntimeContext context) {
        int count;
        String viewCode = currentNode.getViewCode();
        Validate.notNull((Object)viewCode, (String)"\u5728\u57fa\u4e8e\u6570\u636e\u89c6\u56fe\u7684\u6761\u4ef6\u5224\u5b9a\u5904\u7406\u5668\u5de5\u4f5c\u65f6\uff0c\u672a\u53d1\u73b0\u6307\u5b9a\u7684codeView\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e", (Object[])new Object[0]);
        DataViewEntity currentDataView = this.dataViewService.findDetailsByCode(viewCode);
        Validate.notNull((Object)currentDataView, (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u6570\u636e\u89c6\u56fe\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{viewCode});
        String aggregateField = currentNode.getAggregateField();
        Validate.notBlank((CharSequence)aggregateField, (String)"\u672a\u8bbe\u5b9a\u64cd\u4f5c\u5217", (Object[])new Object[0]);
        Integer aggregateType = currentNode.getAggregateType();
        Validate.notNull((Object)aggregateType, (String)"\u64cd\u4f5c\u7c7b\u578b\u5fc5\u987b\u8bbe\u5b9a", (Object[])new Object[0]);
        ExecuteParamModel dataViewParamModel = new ExecuteParamModel();
        dataViewParamModel.setSystemParams(inputParamValues);
        dataViewParamModel.setDataViewCode(currentDataView.getCode());
        Validate.notNull((Object)context.getParams().get("_session"), (String)"\u8bf7\u68c0\u67e5\u4e0a\u4e0b\u6587\u4e2dsession\u4e22\u5931\uff01", (Object[])new Object[0]);
        Session session = (Session)context.getParams().get("_session");
        dataViewParamModel.setSession(session);
        List result = null;
        try {
            result = this.dataViewService.executeQuery(dataViewParamModel);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        Set<RuntimeNodeParams> outputParams = currentNode.getOutputs();
        Validate.isTrue((outputParams == null || outputParams != null && outputParams.size() == 1 ? 1 : 0) != 0, (String)"\u8fd0\u884c\u8282\u70b9[%s]\u65f6\uff0c\u53d1\u73b0\u5176\u8bbe\u5b9a\u7684\u51fa\u53c2\u4e0d\u7b26\u5408\u8981\u6c42(\u8981\u4e48\u4e0d\u8bbe\u5b9a\u8fd4\u56de\u503c\uff0c\u8981\u4e48\u53ea\u8bbe\u7f6e\u4e00\u4e2a\u8fd4\u56de\u503c\u53c2\u6570)!!", (Object[])new Object[0]);
        if (outputParams == null) {
            return;
        }
        RuntimeNodeParams outputParam = outputParams.iterator().next();
        String contextParamName = outputParam.getContextParamName();
        Integer scale = currentNode.getScale() == null ? 0 : currentNode.getScale();
        BigDecimal sum = new BigDecimal(0);
        BigDecimal max = new BigDecimal(Integer.MIN_VALUE);
        BigDecimal min = new BigDecimal(Integer.MAX_VALUE);
        for (count = 0; result != null && count < result.size(); ++count) {
            JSONObject item = (JSONObject)result.get(count);
            Double aggregateFieldValue = null;
            try {
                aggregateFieldValue = item.getDouble(aggregateField);
                if (aggregateFieldValue == null) {
                    throw new IllegalArgumentException();
                }
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException(String.format("\u5728\u6267\u884c\u6570\u636e\u89c6\u56fe[%s].[%s]\u65f6\uff0c\u53d1\u73b0\u4e0d\u4e3a\u6570\u5b57(\u6216\u6ca1\u6709\u8bbe\u5b9a\u9ed8\u8ba4\u503c)\u7684\u8f93\u51fa\u7ed3\u679c\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u89c6\u56fe!!", viewCode, aggregateField), e);
            }
            sum = sum.add(new BigDecimal(aggregateFieldValue));
            if (max.doubleValue() < aggregateFieldValue) {
                max = new BigDecimal(aggregateFieldValue);
            }
            if (!(min.doubleValue() > aggregateFieldValue)) continue;
            min = new BigDecimal(aggregateFieldValue);
        }
        Map<String, Object> contentMap = context.getParams();
        switch (aggregateType) {
            case 1: {
                contentMap.put(contextParamName, count);
                break;
            }
            case 2: {
                contentMap.put(contextParamName, sum.setScale((int)scale, RoundingMode.HALF_UP).doubleValue());
                break;
            }
            case 3: {
                if (count == 0) {
                    contentMap.put(contextParamName, 0);
                    break;
                }
                contentMap.put(contextParamName, sum.divide(new BigDecimal(count), (int)scale, RoundingMode.HALF_UP).setScale((int)scale, RoundingMode.HALF_UP).doubleValue());
                break;
            }
            case 4: {
                contentMap.put(contextParamName, max.setScale((int)scale, RoundingMode.HALF_UP).doubleValue());
                break;
            }
            case 5: {
                contentMap.put(contextParamName, min.setScale((int)scale, RoundingMode.HALF_UP).doubleValue());
                break;
            }
        }
    }

    @Override
    public Class<RuntimeAggregateDataViewNode> mapping() {
        return RuntimeAggregateDataViewNode.class;
    }
}

