package com.bizunited.platform.mars.policy.process.executor.init;

import java.util.concurrent.ThreadPoolExecutor;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import com.bizunited.platform.common.service.init.InitProcessService;
import com.bizunited.platform.mars.policy.process.executor.ReferenceClearRunnable;
import com.bizunited.platform.mars.policy.process.executor.TimerNotifyRunnable;

/**
 * 这个初始化工具，主要用于向mars_timer_thread_pool名称的线程池，填充延时运行节点的消费者任务
 * @author yinwenjie
 */
@Component("MarsRuntimeTimerNotify")
public class MarsRuntimeTimerNotify implements InitProcessService {
  
  @Autowired
  private ApplicationContext app;
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(MarsRuntimeTimerNotify.class);

  @Override
  public boolean doProcess() {
    return true;
  }

  @Override
  public void init() {
    ThreadPoolExecutor timeThreadPoolExecutor = this.app.getBean("mars_timer_thread_pool", ThreadPoolExecutor.class);
    // 开始填充任务（默认为5个）
    for (int index = 0 ; index < 5 ; index++) {
      TimerNotifyRunnable timerNotifyRunnable = this.app.getBean("TimerNotifyRunnable" , TimerNotifyRunnable.class);
      timeThreadPoolExecutor.submit(timerNotifyRunnable);
    }
    
    // 启动基于弱引用的废弃上下文对象清理线程
    ThreadPoolExecutor referenceThreadPoolExecutor = this.app.getBean("mars_reference_thread_pool", ThreadPoolExecutor.class);
    ReferenceClearRunnable referenceNotifyRunnable = this.app.getBean("ReferenceClearRunnable" , ReferenceClearRunnable.class);
    referenceThreadPoolExecutor.submit(referenceNotifyRunnable);
    
    LOGGER.info("mars started ......");
  }
}