package com.bizunited.platform.mars.policy.process.runtime.service;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;

import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import com.bizunited.platform.mars.policy.process.cache.RuntimeDefinition;
import com.bizunited.platform.mars.policy.process.cache.RuntimeNode;
import com.bizunited.platform.mars.policy.process.cache.RuntimeNodeNexts;

@Component("SimpleRuntimeNodeNextsService")
public class SimpleRuntimeNodeNextsService implements RuntimeNodeNextsService {

  @Override
  public Set<RuntimeNodeNexts> findByEndCode(RuntimeDefinition currentDefinition,final String toNodeCode) {
    if(currentDefinition == null || StringUtils.isBlank(toNodeCode)) {
      return null;
    }
    Set<RuntimeNode> runtimeNodes = currentDefinition.getNodes();
    if(CollectionUtils.isEmpty(runtimeNodes)) {
      return null;
    }
    
    // 依次寻找每个连线的结束节点，是否匹配
    Set<RuntimeNodeNexts> result = new LinkedHashSet<>();
    for (RuntimeNode runtimeNode : runtimeNodes) {
      Set<RuntimeNodeNexts> runtimeNodeNexts = runtimeNode.getNexts();
      if(CollectionUtils.isEmpty(runtimeNodeNexts)) {
        continue;
      }
      Set<RuntimeNodeNexts> items = runtimeNodeNexts.stream().filter(item -> StringUtils.equals(item.getToNodeCode(), toNodeCode)).collect(Collectors.toSet());
      result.addAll(items);
    }
    return result;
  }

}
