/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.mars.policy.process.executor;

import com.bizunited.platform.mars.policy.process.cache.RuntimeDefinition;
import com.bizunited.platform.mars.policy.process.cache.RuntimeNode;
import com.bizunited.platform.mars.policy.process.cache.RuntimeNodeNexts;
import com.bizunited.platform.mars.policy.process.cache.RuntimeNodeType;
import com.bizunited.platform.mars.policy.process.cache.RuntimeProcessorLinked;
import com.bizunited.platform.mars.policy.process.cache.ext.RuntimeConditionExtNode;
import com.bizunited.platform.mars.policy.process.cache.ext.RuntimeExtNode;
import com.bizunited.platform.mars.policy.process.cache.ext.RuntimeParallelBranchExtNode;
import com.bizunited.platform.mars.policy.process.cache.waiter.RuntimeDelayNode;
import com.bizunited.platform.mars.policy.process.cache.waiter.RuntimeStartAble;
import com.bizunited.platform.mars.policy.process.executor.ProcessorChain;
import com.bizunited.platform.mars.policy.process.rule.Ruleable;
import com.bizunited.platform.mars.policy.process.rule.ext.AbstractConditionExtRuleable;
import com.bizunited.platform.mars.policy.process.rule.ext.AbstractExtRuleable;
import com.bizunited.platform.mars.policy.process.rule.ext.AbstractParallelBranchExtRuleable;
import com.bizunited.platform.mars.policy.process.runtime.RuleRunTimeStatus;
import com.bizunited.platform.mars.policy.process.runtime.contexts.RuleRuntimeContext;
import com.bizunited.platform.mars.policy.process.runtime.service.RuntimeNodeService;
import com.bizunited.platform.mars.policy.process.runtime.service.RuntimeProcessorLinkedService;
import java.util.List;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.locks.LockSupport;
import javax.persistence.EntityManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.orm.hibernate5.SessionHolder;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Primary
@Component(value="ProcessorLinkedChainRunnable")
@Scope(value="prototype")
public final class ProcessorLinkedChainRunnable
implements ProcessorChain,
Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessorLinkedChainRunnable.class);
    private RuleRuntimeContext ruleRuntimeContext;
    private RuntimeProcessorLinked runtimeProcessorLinked;
    @Autowired
    @Qualifier(value="_delayTimerQueue")
    private DelayQueue<RuntimeDelayNode> delayQueue;
    @Autowired
    private RuntimeNodeService runtimeNodeService;
    @Autowired
    private RuntimeProcessorLinkedService runtimeProcessorLinkedService;
    private int count = 0;
    @Autowired
    private List<Ruleable<RuntimeNode>> ruleables;
    @Autowired
    private List<Ruleable<? extends RuntimeNode>> extRuleables;
    @Autowired
    private EntityManager entityManager;

    public ProcessorLinkedChainRunnable() {
    }

    public ProcessorLinkedChainRunnable(RuleRuntimeContext ruleRuntimeContext, RuntimeProcessorLinked runtimeProcessorLinked) {
        this.ruleRuntimeContext = ruleRuntimeContext;
        this.runtimeProcessorLinked = runtimeProcessorLinked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Session session = (Session)this.entityManager.getDelegate();
        SessionFactory sessionFactory = session.getSessionFactory();
        try (Session newSession = sessionFactory.openSession();){
            SecurityContext ctx = SecurityContextHolder.createEmptyContext();
            ctx.setAuthentication((Authentication)this.ruleRuntimeContext.getParams().get("_authentication"));
            SecurityContextHolder.setContext((SecurityContext)ctx);
            newSession.setHibernateFlushMode(FlushMode.MANUAL);
            if (!TransactionSynchronizationManager.hasResource((Object)sessionFactory)) {
                SessionHolder sessionHolder = new SessionHolder(newSession);
                TransactionSynchronizationManager.bindResource((Object)sessionFactory, (Object)sessionHolder);
                this.ruleRuntimeContext.getParams().put("_session", newSession);
            }
            this.doProcessNode(this.ruleRuntimeContext, this.runtimeProcessorLinked);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            this.ruleRuntimeContext.setCurrentThrowable(e);
            this.ruleRuntimeContext.setExceptionLevel(0);
            this.ruleRuntimeContext.setStatus(RuleRunTimeStatus.EXCEPTION);
            Thread requestThread = this.ruleRuntimeContext.getRequestThread();
            if (requestThread != null) {
                LockSupport.unpark(requestThread);
            }
        }
        finally {
            SecurityContextHolder.clearContext();
            LOGGER.debug("sessionFactory \u91ca\u653e");
            if (TransactionSynchronizationManager.hasResource((Object)sessionFactory)) {
                TransactionSynchronizationManager.unbindResource((Object)sessionFactory);
            }
        }
    }

    @Override
    public void doProcessNode(RuleRuntimeContext context, RuntimeProcessorLinked runtimeProcessorLinked) {
        block15: {
            Validate.notNull((Object)context, (String)"\u89c4\u5219\u5b9e\u4f8b\u4e0a\u4e0b\u6587\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
            Validate.notNull((Object)runtimeProcessorLinked, (String)"\u89c4\u5219\u94fe\u8def\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
            RuntimeNode currentNode = runtimeProcessorLinked.getCurrentNode();
            if (currentNode == null && this.count == 0) {
                currentNode = runtimeProcessorLinked.getFounder();
                this.runtimeProcessorLinkedService.next(runtimeProcessorLinked, currentNode);
            } else if (currentNode == null) {
                Validate.notNull((Object)currentNode, (String)"\u6ca1\u6709\u627e\u5230\u89c4\u5219\u94fe\u8def\u5b9a\u4e49\u7684\u5f00\u59cb\u8282\u70b9\uff0c\u8fd9\u79cd\u60c5\u51b5\u4e00\u822c\u7531\u4e8e\u89c4\u5219\u5b9a\u4e49\u7ed3\u6784\u53d7\u5230\u7834\u574f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            }
            LOGGER.info("\u5f53\u524d\u6267\u884c\u8282\u70b9code\uff1anodeCode\u3010{}\u3011, type\u3010{}\u3011 ", (Object)currentNode.getCode(), (Object)currentNode.getType());
            Integer currentLevel = this.count++;
            Ruleable<RuntimeNode> currentRuleable = this.findRuleable(currentNode);
            Validate.notNull(currentRuleable, (String)"\u6ca1\u53d1\u73b0\u6307\u5b9a\u8fd0\u884c\u65f6\u8282\u70b9[%s]\uff0c\u5bf9\u5e94\u7684\u6267\u884c\u5668Runable\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{currentNode.getClass().getName()});
            if (currentLevel == 0) {
                RuntimeStartAble runtimeStartAble = (RuntimeStartAble)currentNode;
                if (runtimeStartAble.reloadStartNode()) {
                    currentRuleable.doProcess(currentNode, context, runtimeProcessorLinked, this);
                    return;
                }
            } else {
                if (currentNode.getType() == RuntimeNodeType.END) {
                    if (context.getStatus() == RuleRunTimeStatus.EXCEPTION) {
                        throw new IllegalArgumentException(context.getCurrentThrowable().getMessage());
                    }
                    RuntimeDefinition currentDefinition = context.getRuntimeDefinition();
                    String returnParam = currentDefinition.getReturnParam();
                    if (!StringUtils.isBlank((CharSequence)returnParam)) {
                        context.set_return(context.getParams().get(returnParam));
                    }
                    context.setStatus(RuleRunTimeStatus.DONE);
                    LOGGER.info("\u8fd0\u884c\u7ed3\u675f\u8282\u70b9\u3010{}\u3011,\u94fe\u8def\u7f16\u53f7\u3010{}\u3011,\u94fe\u8def\u7248\u672c\u53f7\u3010{}\u3011", new Object[]{currentNode.getCode(), currentDefinition.getCode(), currentDefinition.getCverion()});
                    if (context.getRequestThread() != null) {
                        LockSupport.unpark(context.getRequestThread());
                    }
                    return;
                }
                if (RuntimeStartAble.class.isAssignableFrom(currentNode.getClass()) && currentNode != runtimeProcessorLinked.getFounder()) {
                    RuntimeDelayNode runtimeDelayNode = (RuntimeDelayNode)currentNode;
                    runtimeDelayNode.setRuleRuntimeContext(context);
                    this.runtimeProcessorLinkedService.end(runtimeProcessorLinked, currentNode);
                    this.delayQueue.add(runtimeDelayNode);
                    return;
                }
            }
            RuntimeNodeNexts runtimeNodeNext = null;
            if (currentNode == runtimeProcessorLinked.getFounder()) {
                runtimeNodeNext = runtimeProcessorLinked.getFoundNext();
                Validate.notNull((Object)runtimeNodeNext, (String)"\u6839\u636e\u5f53\u524d\u89c4\u5219\u8fd0\u884c\u65f6\u4e0a\u4e0b\u6587\uff0c\u6ca1\u6709\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u4e0b\u4e00\u8fd0\u884c\u65f6\u8282\u70b9\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
                currentNode = this.runtimeNodeService.findByCodeAndContext(runtimeNodeNext.getToNodeCode(), context);
            } else {
                currentNode = this.runtimeNodeService.findNextByContext(currentNode, context);
                Validate.notNull((Object)currentNode, (String)"\u6839\u636e\u5f53\u524d\u89c4\u5219\u8fd0\u884c\u65f6\u4e0a\u4e0b\u6587\uff0c\u6ca1\u6709\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u4e0b\u4e00\u8fd0\u884c\u65f6\u8282\u70b9\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            }
            currentRuleable = this.findRuleable(currentNode);
            Validate.notNull(currentRuleable, (String)"\u6ca1\u53d1\u73b0\u6307\u5b9a\u8fd0\u884c\u65f6\u8282\u70b9[%s]\uff0c\u5bf9\u5e94\u7684\u6267\u884c\u5668Runable\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{currentNode.getClass().getName()});
            try {
                this.runtimeProcessorLinkedService.next(runtimeProcessorLinked, currentNode);
                currentRuleable.doProcess(currentNode, context, runtimeProcessorLinked, this);
            }
            catch (RuntimeException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                if (context.getStatus() != RuleRunTimeStatus.NORMAL) break block15;
                RuntimeException currente = e;
                context.setCurrentThrowable(currente);
                context.setStatus(RuleRunTimeStatus.EXCEPTION);
                context.setExceptionLevel(currentLevel);
                this.runtimeProcessorLinkedService.exception(runtimeProcessorLinked, currentNode, e);
                Thread requestThread = this.ruleRuntimeContext.getRequestThread();
                if (requestThread == null) break block15;
                LockSupport.unpark(requestThread);
            }
        }
    }

    private Ruleable<RuntimeNode> findRuleable(RuntimeNode currentNode) {
        RuntimeNodeType runtimeNodeType = currentNode.getType();
        if (runtimeNodeType == RuntimeNodeType.CUSTOM && currentNode instanceof RuntimeExtNode) {
            RuntimeExtNode runtimeExtNode = (RuntimeExtNode)currentNode;
            for (Ruleable<RuntimeNode> ruleable : this.extRuleables) {
                AbstractExtRuleable extRuleable;
                int mappingExtType;
                if (!AbstractExtRuleable.class.isAssignableFrom(ruleable.getClass()) || (mappingExtType = (extRuleable = (AbstractExtRuleable)ruleable).mappingExtType()) != runtimeExtNode.getExtType()) continue;
                return ruleable;
            }
        } else if (runtimeNodeType == RuntimeNodeType.CUSTOM_CONCURRENCY && currentNode instanceof RuntimeParallelBranchExtNode) {
            RuntimeParallelBranchExtNode runtimeParallelBranchExtNode = (RuntimeParallelBranchExtNode)currentNode;
            for (Ruleable<RuntimeNode> ruleable : this.extRuleables) {
                AbstractParallelBranchExtRuleable parallelBranchExtRuleable;
                int mappingExtType;
                if (!AbstractParallelBranchExtRuleable.class.isAssignableFrom(ruleable.getClass()) || (mappingExtType = (parallelBranchExtRuleable = (AbstractParallelBranchExtRuleable)ruleable).mappingExtType()) != runtimeParallelBranchExtNode.getExtType()) continue;
                return ruleable;
            }
        } else if (runtimeNodeType == RuntimeNodeType.CUSTOM_CONDITION && currentNode instanceof RuntimeConditionExtNode) {
            RuntimeConditionExtNode runtimeConditionExtNode = (RuntimeConditionExtNode)currentNode;
            for (Ruleable<RuntimeNode> ruleable : this.extRuleables) {
                AbstractConditionExtRuleable conditionExtRuleable;
                int mappingExtType;
                if (!AbstractConditionExtRuleable.class.isAssignableFrom(ruleable.getClass()) || (mappingExtType = (conditionExtRuleable = (AbstractConditionExtRuleable)ruleable).mappingExtType()) != runtimeConditionExtNode.getExtType()) continue;
                return ruleable;
            }
        } else {
            for (Ruleable<RuntimeNode> item : this.ruleables) {
                if (item.mapping() != currentNode.getClass()) continue;
                return item;
            }
        }
        return null;
    }
}

