/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.mars.policy.process.rule.mutex;

import com.bizunited.platform.mars.policy.process.cache.RuntimeDefinition;
import com.bizunited.platform.mars.policy.process.cache.RuntimeProcessorLinked;
import com.bizunited.platform.mars.policy.process.cache.mutex.RuntimeMutexNode;
import com.bizunited.platform.mars.policy.process.executor.ProcessorChain;
import com.bizunited.platform.mars.policy.process.rule.mutex.MutexLockRuleable;
import com.bizunited.platform.mars.policy.process.runtime.contexts.RuleRuntimeContext;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="redisMutexLockRuleable")
public class RedisMutexLockRuleable<T extends RuntimeMutexNode>
implements MutexLockRuleable<RuntimeMutexNode> {
    @Autowired
    private RedissonClient redissonClient;
    @Value(value="${spring.application.name}")
    private String appName;
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisMutexLockRuleable.class);

    @Override
    public void doProcess(RuntimeMutexNode currentNode, RuleRuntimeContext context, RuntimeProcessorLinked runtimeProcessorLinked, ProcessorChain processChain) {
        RuntimeDefinition currentDefinition = context.getRuntimeDefinition();
        String code = currentDefinition.getCode().toString();
        String version = currentDefinition.getCverion().toString();
        String key = StringUtils.join((Object[])new String[]{this.appName, "_", code, "_", version});
        RLock lock = this.redissonClient.getLock(key);
        try {
            lock.lock();
            processChain.doProcessNode(context, runtimeProcessorLinked);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public String description() {
        return "\u57fa\u4e8eredis\u7684\u5206\u5e03\u5f0f\u9501\u5b9e\u73b0\uff0ckey = \u5e94\u7528\u540d_\u89c4\u5219\u5b9a\u4e49code_\u89c4\u5219\u5b9a\u4e49version";
    }

    @Override
    public Class<RuntimeMutexNode> mapping() {
        return RuntimeMutexNode.class;
    }
}

