package com.bizunited.platform.mars.policy.process.cache.logic;

import org.apache.commons.lang3.Validate;

import com.bizunited.platform.mars.entity.RuleNodeEntity;
import com.bizunited.platform.mars.entity.RuleSourceAggregateDataViewEntity;
import com.bizunited.platform.mars.policy.process.cache.Mappable;

/**
 * 节点运行时处理源-数据视图（聚合）
 * @author yinwenjie
 */
public class RuntimeAggregateDataViewNode extends RuntimeLogicAble implements Mappable<RuleNodeEntity, RuntimeAggregateDataViewNode> {
  /**
   * 数据视图业务编号
   */
  private String viewCode;
  /**
   * 数据源编号（如果使用第三方数据源，则需要填写）
   */
  private String dataSourceCode;
  /**
   * 聚集函数对应的视图字段
   */
  private String aggregateField;
  /**
   * SQL集合函数类型：
   * 1、count；2、sum；3、avg；4、max；5、min
   */
  private Integer aggregateType;
  /**
   * 小数保留维数（默认为2）
   */
  private Integer scale = 2;
  public String getViewCode() {
    return viewCode;
  }
  public void setViewCode(String viewCode) {
    this.viewCode = viewCode;
  }
  public String getAggregateField() {
    return aggregateField;
  }
  public void setAggregateField(String aggregateField) {
    this.aggregateField = aggregateField;
  }
  public Integer getAggregateType() {
    return aggregateType;
  }
  public void setAggregateType(Integer aggregateType) {
    this.aggregateType = aggregateType;
  }
  public Integer getScale() {
    return scale;
  }
  public void setScale(Integer scale) {
    this.scale = scale;
  }
  public String getDataSourceCode() {
    return dataSourceCode;
  }
  public void setDataSourceCode(String dataSourceCode) {
    this.dataSourceCode = dataSourceCode;
  }
  @Override
  public RuntimeAggregateDataViewNode mappingTransform(RuleNodeEntity ruleNode) {
    RuntimeAggregateDataViewNode currentNode = super.doMappingTransform(RuntimeAggregateDataViewNode.class, ruleNode);
    RuleSourceAggregateDataViewEntity ruleSourceAggregateDataView = ruleNode.getTemplateNode().getSourceAggregateDataView();
    Validate.notNull(ruleSourceAggregateDataView , "未发现持久层节点模板中指定的数据视图（聚集）信息，请检查!!");
    currentNode.setViewCode(ruleSourceAggregateDataView.getViewCode());
    currentNode.setAggregateField(ruleSourceAggregateDataView.getAggregateField());
    currentNode.setAggregateType(ruleSourceAggregateDataView.getAggregateType());
    
    return currentNode;
  }
}