package com.bizunited.platform.mars.policy.process.cache;

import java.util.HashMap;

import com.bizunited.platform.mars.policy.process.cache.end.RuntimeEndNode;
import com.bizunited.platform.mars.policy.process.cache.ext.RuntimeConditionExtNode;
import com.bizunited.platform.mars.policy.process.cache.ext.RuntimeExtNode;
import com.bizunited.platform.mars.policy.process.cache.ext.RuntimeParallelBranchExtNode;
import com.bizunited.platform.mars.policy.process.cache.logic.RuntimeAggregateDataViewNode;
import com.bizunited.platform.mars.policy.process.cache.logic.RuntimeDataViewNode;
import com.bizunited.platform.mars.policy.process.cache.logic.RuntimeDynamicScriptNode;
import com.bizunited.platform.mars.policy.process.cache.logic.RuntimeScriptNode;
import com.bizunited.platform.mars.policy.process.cache.logic.RuntimeServicableNode;
import com.bizunited.platform.mars.policy.process.cache.mutex.RuntimeMutexNode;
import com.bizunited.platform.mars.policy.process.cache.waiter.RuntimeConcurrentAggregationNode;
import com.bizunited.platform.mars.policy.process.cache.waiter.RuntimeConditionNode;
import com.bizunited.platform.mars.policy.process.cache.waiter.RuntimeParallelBranchNode;
import com.bizunited.platform.mars.policy.process.cache.waiter.RuntimeStartNode;
import com.bizunited.platform.mars.policy.process.cache.waiter.RuntimeTimerNode;

/**
 * 这是一个映射关系类型，记录了不同的node type值和cache中不同运行时节点类型的对应关系
 * @author yinwenjie
 */
public final class RuntimeNodeMapping {
  public static final HashMap<Integer, Class<? extends RuntimeNode>> MAPPING = new HashMap<>();
  
  static {
    MAPPING.put(1, RuntimeConditionNode.class);
    // ========= 各种逻辑节点
    MAPPING.put(21, RuntimeServicableNode.class);
    MAPPING.put(22, RuntimeAggregateDataViewNode.class);
    MAPPING.put(23, RuntimeScriptNode.class);
    // MAPPING.put(24, RuntimeMutexNode.class);
    MAPPING.put(25, RuntimeDynamicScriptNode.class);
    MAPPING.put(26, RuntimeDataViewNode.class);
    // ========
    MAPPING.put(3, RuntimeMutexNode.class);
    MAPPING.put(4, RuntimeStartNode.class);
    MAPPING.put(5, RuntimeEndNode.class);
    MAPPING.put(6, RuntimeParallelBranchNode.class);
    MAPPING.put(7, RuntimeConcurrentAggregationNode.class);
    MAPPING.put(8, RuntimeTimerNode.class);
    // 自定义业务节点
    MAPPING.put(9, RuntimeExtNode.class);
    // 自定义A/B并发节点
    MAPPING.put(10, RuntimeParallelBranchExtNode.class);
    // 自定义条件判定节点
    MAPPING.put(11, RuntimeConditionExtNode.class);
  }
}
