package com.bizunited.platform.mars.policy.process.runtime.service;

import java.util.Set;

import com.bizunited.platform.mars.policy.process.cache.RuntimeDefinition;
import com.bizunited.platform.mars.policy.process.cache.RuntimeNode;
import com.bizunited.platform.mars.policy.process.cache.RuntimeProcessorLinked;
import com.bizunited.platform.mars.policy.process.runtime.contexts.RuleRuntimeContext;

/**
 * 则实例运行所需要的完整规则节点信息，在这里被进行查询、操作和缓存
 * @author yinwenjie
 */
public interface RuntimeNodeService {
  /**
   * 根据当前规则运行时信息，寻找这个规则定义的开始节点
   * @return
   */
  RuntimeNode findStartByDefinition(RuntimeDefinition currentDefinition);
  /**
   * 根据当前规则链路定义信息，寻找这个链路定义的开始节点
   * @param runtimeProcessorLinked
   * @return
   */
  RuntimeNode findStartByRuntimeProcessorLinked(RuntimeProcessorLinked runtimeProcessorLinked);
  /**
   * 根据当前规则运行时信息，寻找这个规则定义的结束节点（一个或者多个）
   * @param currentDefinition 
   * @return
   */
  Set<RuntimeNode> findEndByDefinition(RuntimeDefinition currentDefinition);
  /**
   * 根据当前规则运行时信息，根据节点的唯一code进行节点运行时的查询
   * @param nodeCode 
   * @param processDefinition 
   * @return 
   */
  RuntimeNode findByCodeAndContext(String nodeCode , RuleRuntimeContext context);
  /**
   * 根据当前的节点信息，基于当前运行的上下文信息，获取后续的运行节点信息</br>
   * 注意，这些节点都是正常规则连线场景下的后续运行时节点，且只能处理只存在但连线的节点连接场景</br>
   * 这是因为多连线的场景是使用ruleable中创建规则链接的方法进行处理的
   * @param processDefinition 
   * @return 
   */
  RuntimeNode findNextByContext(RuntimeNode currentNode , RuleRuntimeContext context);
  /**
   * 根据当前的节点信息，基于当前运行的上下文信息，获取后续的运行节点信息</br>
   * 注意，这些节点都是正常规则连线场景下的后续运行时节点
   * @param processDefinition
   * @return
   */
  RuntimeNode findExceptionNextByContext(RuntimeNode currentNode , RuleRuntimeContext context);
}