/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.mars.policy.process.configuration;

import com.bizunited.platform.mars.policy.process.configuration.MarsExecutorProperties;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MarsExecutorConfig {
    @Autowired
    private MarsExecutorProperties marsExecutorProperties;

    @Bean(value={"mars_timer_thread_pool"})
    public ThreadPoolExecutor getMarsTimerThreadPool() {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(this.marsExecutorProperties.getTimerAcceptorSize(), this.marsExecutorProperties.getTimerAcceptorSize(), 0L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>());
        threadPoolExecutor.setThreadFactory(new MarsTimerThreadFactory());
        return threadPoolExecutor;
    }

    @Bean(value={"mars_extcutor_thread_pool"})
    public ThreadPoolExecutor getMarsExtcutorThreadPool() {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(this.marsExecutorProperties.getExtcutorInitSize(), this.marsExecutorProperties.getExtcutorMaxSize(), 30L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(1000));
        threadPoolExecutor.setThreadFactory(new MarsExtcutorThreadFactory());
        return threadPoolExecutor;
    }

    @Bean(value={"mars_reference_thread_pool"})
    public ThreadPoolExecutor getMarsReferenceThreadPool() {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>());
        threadPoolExecutor.setThreadFactory(new MarsReferenceThreadFactory());
        return threadPoolExecutor;
    }

    public static class MarsExtcutorThreadFactory
    implements ThreadFactory {
        private static AtomicInteger count = new AtomicInteger(1);

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "mars_extcutor_thread_" + count.getAndIncrement());
            return thread;
        }
    }

    public static class MarsTimerThreadFactory
    implements ThreadFactory {
        private static AtomicInteger count = new AtomicInteger(1);

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "mars_timer_thread_" + count.getAndIncrement());
            return thread;
        }
    }

    public static class MarsReferenceThreadFactory
    implements ThreadFactory {
        private static AtomicInteger count = new AtomicInteger(1);

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "mars_reference_thread_" + count.getAndIncrement());
            return thread;
        }
    }
}

