package com.bizunited.platform.mars.policy.process.cache.waiter;

import com.bizunited.platform.mars.entity.RuleNodeEntity;
import com.bizunited.platform.mars.entity.RuleTimerNodeEntity;
import com.bizunited.platform.mars.policy.process.cache.Mappable;
import org.apache.commons.lang3.Validate;

/**
 * 计时等待节点的运行时定义
 *
 * @author yinwenjie
 */
public class RuntimeTimerNode extends RuntimeDelayNode implements Mappable<RuleNodeEntity, RuntimeTimerNode> {

  /**
   * 时间阻塞节点是需要真正进行延迟的节点
   */
  @Override
  public boolean realDelayed() {
    return true;
  }

  @Override
  public RuntimeTimerNode mappingTransform(RuleNodeEntity ruleNode) {
    RuntimeTimerNode runtimeTimerNode = super.doMappingTransform(RuntimeTimerNode.class, ruleNode);
    RuleTimerNodeEntity ruleTimerNode = ruleNode.getRuleTimerExt();
    Validate.notNull(ruleTimerNode, "延迟执行节点的扩展信息，未被发现，请检查!!");
    // 目前只记录秒数即可
    int timerCount = ruleTimerNode.getTimerCount();
    int timeUnit = ruleTimerNode.getTimeUnit();
    Validate.isTrue(timerCount > 0, "延迟等待节点的时间必须大于0秒!!");
    Validate.isTrue(timeUnit > 0, "延迟等待节点的时间单位类型必须存在!!");
    switch (timeUnit) {
      case 1:
        runtimeTimerNode.setTimerCount(timerCount);
        break;
      case 2:
        runtimeTimerNode.setTimerCount(timerCount * 60);
        break;
      case 3:
        runtimeTimerNode.setTimerCount(timerCount * 60 * 60);
        break;
      case 4:
        runtimeTimerNode.setTimerCount(timerCount * 60 * 60 * 24);
        break;
      default:
        throw new IllegalArgumentException("延迟等待节点的单位错误，请检查!");
    }
    return runtimeTimerNode;
  }
}