package com.bizunited.platform.mars.policy.process.configuration;

import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 这是一个专门的spring配置器，里面配置了两个线程池</br>
 * mars_timer_thread_pool：该线程池专门用于处理starterable性质的节点的启动信号工作；</br>
 * mars_extcutor_thread_pool：该线程池专门用于正式执行规则链路定义
 * @author yinwenjie
 */
@Configuration
public class MarsExecutorConfig {
  @Autowired
  private MarsExecutorProperties marsExecutorProperties;
  
  /**
   * 该线程池专门用于处理starterable性质的节点的启动信号工作
   * @return
   */
  @Bean("mars_timer_thread_pool")
  public ThreadPoolExecutor getMarsTimerThreadPool() {
    ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(marsExecutorProperties.getTimerAcceptorSize(), marsExecutorProperties.getTimerAcceptorSize(), 0, TimeUnit.SECONDS, new LinkedBlockingDeque<>());
    threadPoolExecutor.setThreadFactory(new MarsTimerThreadFactory());
    return threadPoolExecutor;
  }
  
  /**
   * 该线程池专门用于正式执行规则链路定义
   * @return
   */
  @Bean("mars_extcutor_thread_pool")
  public ThreadPoolExecutor getMarsExtcutorThreadPool() {
    // TODO 可能需要加入拒绝策略，到时候看压力测试的情况再说
    ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(marsExecutorProperties.getExtcutorInitSize(), marsExecutorProperties.getExtcutorMaxSize(), 30, TimeUnit.SECONDS, new LinkedBlockingDeque<>(1000));
    threadPoolExecutor.setThreadFactory(new MarsExtcutorThreadFactory());
    return threadPoolExecutor;
  }
  
  /**
   * 该线程池专门用于清理规则运行时上下文中不再使用的上下文对象
   * @return
   */
  @Bean("mars_reference_thread_pool")
  public ThreadPoolExecutor getMarsReferenceThreadPool() {
    ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(1, 1, 0, TimeUnit.SECONDS, new LinkedBlockingDeque<>());
    threadPoolExecutor.setThreadFactory(new MarsReferenceThreadFactory());
    return threadPoolExecutor;
  }
  
  /**
   * 该类用于为mars_reference_thread_pool线程池创建工作线程，工作线程本身不需要托管给spring
   * @author yinwenjie
   */
  public static class MarsReferenceThreadFactory implements ThreadFactory {
    private static AtomicInteger count = new AtomicInteger(1);
    
    @Override
    public Thread newThread(Runnable r) {
      Thread thread = new Thread(r , "mars_reference_thread_" + count.getAndIncrement());
      return thread;
    }
  }
  
  /**
   * 该类用于为mars_timer_thread_pool线程池创建工作线程，工作线程本身不需要托管给spring
   * @author yinwenjie
   */
  public static class MarsTimerThreadFactory implements ThreadFactory {
    private static AtomicInteger count = new AtomicInteger(1);
    
    @Override
    public Thread newThread(Runnable r) {
      Thread thread = new Thread(r , "mars_timer_thread_" + count.getAndIncrement());
      return thread;
    }
  }
  
  /**
   * 该类用于为mars_extcutor_thread_pool线程池创建工作线程，工作线程本身不需要托管给spring
   * @author yinwenjie
   */
  public static class MarsExtcutorThreadFactory implements ThreadFactory {
    private static AtomicInteger count = new AtomicInteger(1);
    
    @Override
    public Thread newThread(Runnable r) {
      Thread thread = new Thread(r , "mars_extcutor_thread_" + count.getAndIncrement());
      return thread;
    }
  }
}
