package com.bizunited.platform.mars.policy.process.rule;

import com.bizunited.platform.mars.policy.process.cache.RuntimeNode;
import com.bizunited.platform.mars.policy.process.cache.RuntimeProcessorLinked;
import com.bizunited.platform.mars.policy.process.executor.ProcessorChain;
import com.bizunited.platform.mars.policy.process.runtime.contexts.RuleRuntimeContext;

/**
 * 这是一个标识接口，标记以下的实现类，都是被定义的规则描述节点</br>
 * 可能是开始节点、可能是条件节点、可能是处理节点，等等
 * @author yinwenjie
 */
public interface Ruleable<T extends RuntimeNode> {
  
  /**
   * 一个处理器肯定是对应了一种节点运行时类的，而该方法就是为了向executor指明
   * @return
   */
  Class<T> mapping();
  
  /**
   * 节点执行器应该明确指定所支持的节点类型
   * @return
   */
  default int getType() {
    Class<?> clazz = this.getClass();
    String className = clazz.getName();
    throw new IllegalArgumentException(String.format("当前节点执行器[%s]，并没有正确指定其所支持的节点类型，请检查!!", className));
  }
  
  /**
   * 规则节点运行时所使用的处理器，这些处理器将通过该方法完成各自的处理逻辑。</br>
   * 规则定义的运行基于类似servlet filter的多元递归，所以在每个处理节点运行后，都应该使用类似如下代码，驱动整个规则运行过程向后流动：</p>
   * <code>
   * processChain.doProcessNode(outputs)
   * </code>
   * 
   * @param currentNode 当前正在处理的运行时节点
   * @param context 规则引擎运行时上下文
   * @param runtimeProcessorLinked 当前节点运行时所属的规则链路定义
   * @param processChain 规则执行的控制器
   */
  void doProcess(final T currentNode , final RuleRuntimeContext context , RuntimeProcessorLinked runtimeProcessorLinked , final ProcessorChain processChain);
}