package com.bizunited.platform.mars.policy.process.configuration;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

/**
 * mars运行时所需要的两个线程池的基本配置信息，都在这里；这些配置信息，都存在默认值</br>
 * @author yinwenjie
 */
@Configuration
@Component
public class MarsExecutorProperties {
  /**
   * 用于处理starterable性质的节点的启动信号工作的线程池大小，默认为5
   */
  @Value("${mars.pool.timerAcceptorSize:5}")
  private int timerAcceptorSize;
  /**
   * 专门用于正式执行规则链路定义的线程池初始化大小
   */
  @Value("${mars.pool.extcutorInitSize:10}")
  private int extcutorInitSize;
  /**
   * 专门用于正式执行规则链路定义的线程池最大大小
   */
  @Value("${mars.pool.extcutorMaxSize:100}")
  private int extcutorMaxSize;
  /**
   * 专门用于A/B并行分支拆分参数运算使用的线程池初始化大小 默认为1
   */
  @Value("${mars.pool.taskInitSize:1}")
  private int taskInitSize;
  /**
   * 专门用于A/B并行分支拆分参数运算使用的线程池最大大小 默认为5
   */
  @Value("${mars.pool.taskMaxSize:5}")
  private int taskMaxSize;
  public int getTimerAcceptorSize() {
    return timerAcceptorSize;
  }
  public void setTimerAcceptorSize(int timerAcceptorSize) {
    this.timerAcceptorSize = timerAcceptorSize;
  }
  public int getExtcutorInitSize() {
    return extcutorInitSize;
  }
  public void setExtcutorInitSize(int extcutorInitSize) {
    this.extcutorInitSize = extcutorInitSize;
  }
  public int getExtcutorMaxSize() {
    return extcutorMaxSize;
  }
  public void setExtcutorMaxSize(int extcutorMaxSize) {
    this.extcutorMaxSize = extcutorMaxSize;
  }
  public int getTaskInitSize() {
    return taskInitSize;
  }
  public void setTaskInitSize(int taskInitSize) {
    this.taskInitSize = taskInitSize;
  }
  public int getTaskMaxSize() {
    return taskMaxSize;
  }
  public void setTaskMaxSize(int taskMaxSize) {
    this.taskMaxSize = taskMaxSize;
  }
}
