package com.bizunited.platform.mars.policy.process.rule.ext;

import com.bizunited.platform.mars.policy.process.cache.RuntimeNodeType;
import com.bizunited.platform.mars.policy.process.cache.RuntimeProcessorLinked;
import com.bizunited.platform.mars.policy.process.cache.ext.RuntimeParallelBranchExtNode;
import com.bizunited.platform.mars.policy.process.executor.ProcessorChain;
import com.bizunited.platform.mars.policy.process.runtime.contexts.RuleRuntimeContext;

/**
 * @author Keller
 */
public abstract class AbstractParallelBranchExtRuleable implements ParallelBranchExtRuleable<RuntimeParallelBranchExtNode> {

  /**
   * 所有AbstractExtRuleable处理器的子类，都需要实现该方法，用于向执行器说明
   * 作为业务扩展节点的处理器，本身支持的业务节点扩展类型值是多少
   * @return
   */
  public abstract int mappingExtType();

  /**
   * 业务扩展节点就不再是通过运行时节点runtimeNode的具体类来匹配处理器了</br>
   * 而是通过type和extType来匹配处理器了，所以该方法一直返回null，且不再允许被覆盖
   */
  @Override
  public final Class<RuntimeParallelBranchExtNode> mapping() {
    return null;
  }


  @Override
  public final int getType() {
    return RuntimeNodeType.CUSTOM_CONCURRENCY.getValue();
  }

  /**
   * 业务扩展条件节点为开始节点，无上一步节点，默认进行下一步的调用。
   * @param currentNode 当前正在处理的运行时节点
   * @param context 规则引擎运行时上下文
   * @param runtimeProcessorLinked 当前节点运行时所属的规则链路定义
   * @param processChain 规则执行的控制器
   */
  @Override
  public final void doProcess(RuntimeParallelBranchExtNode currentNode, RuleRuntimeContext context, RuntimeProcessorLinked runtimeProcessorLinked, ProcessorChain processChain) {
    processChain.doProcessNode(context, runtimeProcessorLinked);
  }
}
