/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.mars.policy.process.rule.conditions;

import com.bizunited.platform.core.service.ScriptService;
import com.bizunited.platform.mars.policy.process.cache.RuntimeNodeNexts;
import com.bizunited.platform.mars.policy.process.cache.RuntimeNodeType;
import com.bizunited.platform.mars.policy.process.cache.RuntimeProcessorLinked;
import com.bizunited.platform.mars.policy.process.cache.waiter.RuntimeConditionNode;
import com.bizunited.platform.mars.policy.process.executor.ProcessorChain;
import com.bizunited.platform.mars.policy.process.rule.conditions.ConditionRuleable;
import com.bizunited.platform.mars.policy.process.runtime.contexts.RuleRuntimeContext;
import com.bizunited.platform.mars.policy.process.runtime.service.RuntimeDefinitionService;
import com.bizunited.platform.mars.policy.process.runtime.service.RuntimeNodeService;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Sets;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="simpleConditionRuleable")
public class SimpleConditionRuleable<T extends RuntimeConditionNode>
implements ConditionRuleable<RuntimeConditionNode> {
    @Autowired
    private RuntimeNodeService runtimeNodeService;
    @Autowired
    private RuntimeDefinitionService runtimeDefinitionService;
    @Autowired
    private ScriptService scriptService;

    @Override
    public int getType() {
        return RuntimeNodeType.CONDITION.getValue();
    }

    @Override
    public void doProcess(RuntimeConditionNode currentNode, RuleRuntimeContext context, RuntimeProcessorLinked runtimeProcessorLinked, ProcessorChain processChain) {
        processChain.doProcessNode(context, runtimeProcessorLinked);
    }

    @Override
    public Set<RuntimeProcessorLinked> createProcessorLinkeds(RuntimeConditionNode currentNode, RuleRuntimeContext context) {
        Set<RuntimeNodeNexts> nexts = currentNode.getNexts();
        RuntimeNodeType type = currentNode.getType();
        Validate.isTrue((type == RuntimeNodeType.CONDITION ? 1 : 0) != 0, (String)"\u5f53\u524d\u8282\u70b9\u4e0d\u662f\u6761\u4ef6\u7c7b\u578b\u7684\u8fd0\u884c\u65f6\u8282\u70b9\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Set sortNexts = nexts.stream().filter(item -> item.getLineType() == 1).sorted((source, target) -> source.getSort() - target.getSort()).collect(Collectors.toSet());
        RuntimeNodeNexts currentNext = null;
        for (RuntimeNodeNexts next : sortNexts) {
            String conditions = next.getConditions();
            if (StringUtils.isBlank((CharSequence)conditions)) continue;
            Object evalResult = this.executeGroovyScript(conditions, context.getParams());
            if (evalResult == null || Boolean.class != evalResult.getClass()) {
                throw new IllegalArgumentException("\u6761\u4ef6\u5224\u5b9a\u5206\u652f\u7684\u8fd4\u56de\u503c\uff0c\u53ea\u80fd\u662fboolean\u578b\uff0c\u8bf7\u68c0\u67e5!!");
            }
            if (!((Boolean)evalResult).booleanValue()) continue;
            currentNext = next;
            break;
        }
        if (currentNext == null) {
            currentNext = sortNexts.stream().filter(item -> StringUtils.isBlank((CharSequence)item.getConditions())).findFirst().orElse(null);
        }
        Validate.notNull(currentNext, (String)"\u672a\u53d1\u73b0\u4efb\u4f55\u7b26\u5408\u6761\u4ef6\u7684\u8fd0\u884c\u5206\u652f\uff0c\u4e5f\u6ca1\u6709\u53d1\u73b0\u672a\u8bbe\u7f6e\u8fd0\u884c\u6761\u4ef6\u7684\u9ed8\u8ba4\u5206\u652f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        RuntimeProcessorLinked runtimeProcessorLinked = new RuntimeProcessorLinked(currentNode, currentNext);
        return Sets.newHashSet((Object[])new RuntimeProcessorLinked[]{runtimeProcessorLinked});
    }

    private Object executeGroovyScript(String scriptContxt, Map<String, Object> contentMap) {
        HashMap<String, Object> scriptInputsMap = new HashMap<String, Object>(contentMap);
        scriptInputsMap.put("runtimeNodeService", this.runtimeNodeService);
        scriptInputsMap.put("runtimeDefinitionService", this.runtimeDefinitionService);
        return this.scriptService.invoke(scriptContxt, scriptInputsMap);
    }

    @Override
    public Class<RuntimeConditionNode> mapping() {
        return RuntimeConditionNode.class;
    }
}

