package com.bizunited.platform.mars.policy.process.cache.logic;

import org.apache.commons.lang3.Validate;

import com.bizunited.platform.mars.entity.RuleNodeEntity;
import com.bizunited.platform.mars.entity.RuleSourceScriptEntity;
import com.bizunited.platform.mars.entity.RuleTemplateNodeEntity;
import com.bizunited.platform.mars.policy.process.cache.Mappable;

/**
 * 节点运行时处理源-goovy脚本</br>
 * 需要运行的groovy执行脚本内容。</br>
   * 执行groovy所需呀的入参和出参信息，在RuntimeNode中通过inputs、outputs进行确认
 * @author yinwenjie
 */
public class RuntimeScriptNode extends RuntimeLogicAble implements Mappable<RuleNodeEntity, RuntimeScriptNode> {
  /**
   * 运行脚本使用nebula自身的脚本运行支持特性进行
   * 也就是说创建的脚本运行类型的模板节点在scrpt模块中全部可见
   */
  private String scriptId;
  /**
   * 脚本语言（目前只支持groovy）
   */
  private String language;
  /**
   * 脚本内容
   */
  private String scriptContent;
  /**
   * 存储脚本内容所使用的后端完整文件的目录
   */
  private String fileCode;
  /**
   * 存储脚本内容所使用的后端完整文件名
   */
  private String fileName;
  
  public String getScriptId() {
    return scriptId;
  }
  public void setScriptId(String scriptId) {
    this.scriptId = scriptId;
  }
  public String getLanguage() {
    return language;
  }
  public void setLanguage(String language) {
    this.language = language;
  }
  public String getScriptContent() {
    return scriptContent;
  }
  public void setScriptContent(String scriptContent) {
    this.scriptContent = scriptContent;
  }
  public String getFileCode() {
    return fileCode;
  }
  public void setFileCode(String fileCode) {
    this.fileCode = fileCode;
  }
  public String getFileName() {
    return fileName;
  }
  public void setFileName(String fileName) {
    this.fileName = fileName;
  }
  @Override
  public RuntimeScriptNode mappingTransform(RuleNodeEntity ruleNode) {
    /*
     * 脚本内容在节点定义对应的节点模板中
     * */
    RuntimeScriptNode currentNode = super.doMappingTransform(RuntimeScriptNode.class, ruleNode);
    RuleTemplateNodeEntity ruleTemplateNode = ruleNode.getTemplateNode();
    RuleSourceScriptEntity ruleSourceScript = ruleTemplateNode.getSourceScript();
    Validate.notNull(ruleSourceScript , "错误的脚本模板，未发现脚本模板中的groovy脚本内容信息");

    // 进行特定值赋予
    currentNode.setScriptId(ruleSourceScript.getId());
    return currentNode;
  }
}