package com.bizunited.platform.mars.policy.process.executor;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.bizunited.platform.mars.policy.process.runtime.contexts.RuleRuntimeContext;

/**
 * 该执行过程用于清理没有再被使用的规则实例上下文
 * @author yinwenjie
 */
@Primary
@Component("ReferenceClearRunnable")
@Scope("prototype")
public class ReferenceClearRunnable implements Runnable {
  
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(ReferenceClearRunnable.class);
  
  @Override
  public void run() {
    ReferenceQueue<RuleRuntimeContext> referenceQueue = RuleRuntimeContext.referenceQueue;
    int count = 0 ;
    while(count < Integer.MAX_VALUE) {
      try {
        this.remove(referenceQueue);
      } catch(RuntimeException | InterruptedException e) {
        LOGGER.error(e.getMessage() , e);
      }
    }
  }
  
  private void remove(ReferenceQueue<RuleRuntimeContext> referenceQueue) throws InterruptedException {
    Reference<? extends RuleRuntimeContext> reference = referenceQueue.remove();
    RuleRuntimeContext.clearRuleRuntimeContext(reference);
  }
}