/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.mars.policy.process.runtime.contexts;

import com.bizunited.platform.mars.policy.process.cache.RuntimeDefinition;
import com.bizunited.platform.mars.policy.process.cache.RuntimeProcessorLinked;
import com.bizunited.platform.mars.policy.process.runtime.RuleRunTimeStatus;
import com.bizunited.platform.mars.policy.process.runtime.service.EndRuleableCallback;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RuleRuntimeContext {
    private static Map<String, WeakReference<RuleRuntimeContext>> ruleRuntimeContexts = new ConcurrentHashMap<String, WeakReference<RuleRuntimeContext>>();
    public static ReferenceQueue<RuleRuntimeContext> referenceQueue = new ReferenceQueue();
    private Thread requestThread;
    private volatile RuleRunTimeStatus status;
    private Map<String, Object> params = new ConcurrentHashMap<String, Object>();
    private Set<RuntimeProcessorLinked> runtimeProcessorLinkeds = new ConcurrentSkipListSet<RuntimeProcessorLinked>();
    private volatile Object _return;
    private Throwable currentThrowable;
    private Integer exceptionLevel;
    private RuntimeDefinition runtimeDefinition;
    private EndRuleableCallback endRuleableCallback;
    private static final Logger LOGGER = LoggerFactory.getLogger(RuleRuntimeContext.class);

    public RuleRuntimeContext(Thread requestThread) {
        this.requestThread = requestThread;
    }

    public Thread getRequestThread() {
        return this.requestThread;
    }

    public void setRequestThread(Thread requestThread) {
        this.requestThread = requestThread;
    }

    public RuleRunTimeStatus getStatus() {
        return this.status;
    }

    public void setStatus(RuleRunTimeStatus status) {
        this.status = status;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public Object get_return() {
        return this._return;
    }

    public void set_return(Object _return) {
        this._return = _return;
    }

    public Throwable getCurrentThrowable() {
        return this.currentThrowable;
    }

    public void setCurrentThrowable(Throwable currentThrowable) {
        this.currentThrowable = currentThrowable;
    }

    public Integer getExceptionLevel() {
        return this.exceptionLevel;
    }

    public void setExceptionLevel(Integer exceptionLevel) {
        this.exceptionLevel = exceptionLevel;
    }

    public RuntimeDefinition getRuntimeDefinition() {
        return this.runtimeDefinition;
    }

    public void setRuntimeDefinition(RuntimeDefinition runtimeDefinition) {
        this.runtimeDefinition = runtimeDefinition;
    }

    public Set<RuntimeProcessorLinked> getRuntimeProcessorLinkeds() {
        return this.runtimeProcessorLinkeds;
    }

    public void addRuntimeProcessorLinkeds(RuntimeProcessorLinked runtimeProcessorLinked) {
        this.runtimeProcessorLinkeds.add(runtimeProcessorLinked);
    }

    public EndRuleableCallback getEndRuleableCallback() {
        return this.endRuleableCallback;
    }

    public void setEndRuleableCallback(EndRuleableCallback endRuleableCallback) {
        this.endRuleableCallback = endRuleableCallback;
    }

    public static RuleRuntimeContext getRuleRuntimeContext(String instanceId) {
        WeakReference<RuleRuntimeContext> refs = ruleRuntimeContexts.get(instanceId);
        return (RuleRuntimeContext)refs.get();
    }

    public static void setRuleRuntimeContext(String instanceId, RuleRuntimeContext ruleRuntimeContext) {
        Validate.notNull((Object)ruleRuntimeContext, (String)"\u9519\u8bef\u7684\u89c4\u5219\u5b9e\u4f8b\u4e0a\u4e0b\u6587\u4fe1\u606f[null]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        WeakReference<RuleRuntimeContext> refs = new WeakReference<RuleRuntimeContext>(ruleRuntimeContext, referenceQueue);
        ruleRuntimeContexts.put(instanceId, refs);
    }

    public static void clearRuleRuntimeContext(Reference<? extends RuleRuntimeContext> reference) {
        Set<Map.Entry<String, WeakReference<RuleRuntimeContext>>> enties = ruleRuntimeContexts.entrySet();
        enties.spliterator().forEachRemaining(item -> {
            if (item.getValue() == reference) {
                String key = (String)item.getKey();
                ruleRuntimeContexts.remove(key);
                LOGGER.info("\u9057\u7559\u89c4\u5219\u5b9e\u4f8b\u4e0a\u4e0b\u6587\u3010" + key + "\u3011\u5df2\u88ab\u6e05\u7406=====");
                return;
            }
        });
    }
}

