package com.bizunited.platform.mars.policy.process.rule.starter;

import java.util.Set;

import com.bizunited.platform.mars.policy.process.cache.RuntimeNodeType;
import com.bizunited.platform.mars.policy.process.cache.RuntimeProcessorLinked;
import com.bizunited.platform.mars.policy.process.cache.waiter.RuntimeDelayNode;
import com.bizunited.platform.mars.policy.process.rule.Ruleable;
import com.bizunited.platform.mars.policy.process.runtime.contexts.RuleRuntimeContext;

/**
 * 规则模板开始处的规则接口定义</br>
 * 一个规则模板只能有一个开始节点
 * @author yinwenjie 
 */
public interface StarterRuleable<T extends RuntimeDelayNode> extends Ruleable<T> {
  default public int getType() {
    return RuntimeNodeType.BEGIN.getValue();
  }
  /**
   * 该方法表示需要判定以当前节点所在规则定义中某一条规则链路开始的节点，是否能够被执行
   * @param currentNode 
   * @param context 
   * @param processChain 
   * @return 如果可以继续，那么这个节点将通过该方法，负责创建一个初始状态的规则链路，规则链路将指明将继续向下运行的箭头（RuntimeNodeNexts）方向
   */
  public Set<RuntimeProcessorLinked> createProcessorLinkeds(final T currentNode , final RuleRuntimeContext context);
}